/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.dao.api.GenericPersistenceAccessor;
import org.opennms.netmgt.graph.api.NodeRef;
import org.opennms.netmgt.graph.api.NodeService;
import org.opennms.netmgt.graph.api.info.IpInfo;
import org.opennms.netmgt.graph.api.info.NodeInfo;
import org.opennms.netmgt.graph.api.info.StatusInfo;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.model.alarm.AlarmSummary;

public class DefaultNodeService
implements NodeService {
    private final GenericPersistenceAccessor accessor;
    private final AlarmDao alarmDao;

    public DefaultNodeService(GenericPersistenceAccessor accessor, AlarmDao alarmDao) {
        this.accessor = Objects.requireNonNull(accessor);
        this.alarmDao = Objects.requireNonNull(alarmDao);
    }

    public List<NodeInfo> resolveNodes(List<NodeRef> nodeRefs) {
        Objects.requireNonNull(nodeRefs);
        List<OnmsNode> nodes = this.loadNodes(nodeRefs);
        List<NodeInfo> nodeInfoList = nodes.stream().map(node -> {
            Set categories = node.getCategories().stream().map(OnmsCategory::getName).collect(Collectors.toSet());
            List ipInfoList = node.getIpInterfaces().stream().map(ifc -> new IpInfo(ifc.getIpAddress(), ifc.isPrimary(), ifc.isManaged())).collect(Collectors.toList());
            return new NodeInfo.NodeInfoBuilder().id(node.getId()).label(node.getLabel()).foreignId(node.getForeignId()).foreignSource(node.getForeignSource()).location(node.getLocation().getLocationName()).categories(categories).ipInterfaces(ipInfoList).build();
        }).collect(Collectors.toList());
        return nodeInfoList;
    }

    public Map<NodeRef, StatusInfo> resolveStatus(List<NodeRef> nodeRefs) {
        HashMap<Integer, NodeRef> nodeIdNodeRefMap = new HashMap<Integer, NodeRef>();
        nodeRefs.stream().filter(nodeRef -> nodeRef.getNodeId() != null).forEach(nr -> nodeIdNodeRefMap.put(nr.getNodeId(), (NodeRef)nr));
        List<NodeRef> foreignIdNodeRefs = nodeRefs.stream().filter(nodeRef -> nodeRef.getNodeId() == null).collect(Collectors.toList());
        List<OnmsNode> nodes = this.loadNodes(foreignIdNodeRefs);
        for (OnmsNode eachNode : nodes) {
            for (NodeRef eachRef : nodeRefs) {
                if (!eachRef.matches(eachNode)) continue;
                nodeIdNodeRefMap.put(eachNode.getId(), eachRef);
            }
        }
        Map<Integer, AlarmSummary> nodeIdToAlarmSummaryMap = this.getAlarmSummaries(nodeIdNodeRefMap.keySet());
        HashMap resultMap = Maps.newHashMap();
        for (Integer nodeId : nodeIdNodeRefMap.keySet()) {
            AlarmSummary alarmSummary = nodeIdToAlarmSummaryMap.get(nodeId);
            StatusInfo status = alarmSummary == null ? StatusInfo.defaultStatus().build() : StatusInfo.builder((OnmsSeverity)alarmSummary.getMaxSeverity()).count(alarmSummary.getAlarmCount()).build();
            NodeRef nodeRef2 = (NodeRef)nodeIdNodeRefMap.get(nodeId);
            resultMap.put(nodeRef2, status);
        }
        return resultMap;
    }

    private Map<Integer, AlarmSummary> getAlarmSummaries(Set<Integer> nodeIds) {
        return this.alarmDao.getNodeAlarmSummariesIncludeAcknowledgedOnes((List)Lists.newArrayList(nodeIds)).stream().collect(Collectors.toMap(AlarmSummary::getNodeId, Function.identity()));
    }

    private List<OnmsNode> loadNodes(List<NodeRef> nodeRefs) {
        List<Integer> nodeIds = nodeRefs.stream().map(n -> n.getNodeId()).filter(id -> id != null).collect(Collectors.toList());
        List<String> foreignSources = nodeRefs.stream().map(n -> n.getForeignSource()).filter(fs -> fs != null).distinct().collect(Collectors.toList());
        List<String> foreignIds = nodeRefs.stream().map(n -> n.getForeignId()).filter(fid -> fid != null).distinct().collect(Collectors.toList());
        List<OnmsNode> nodes = new NodeQuery().execute(nodeIds, foreignSources, foreignIds);
        return nodes;
    }

    private final class NodeQuery {
        private NodeQuery() {
        }

        public List<OnmsNode> execute(List<Integer> nodeIds, List<String> foreignSources, List<String> foreignIds) {
            Objects.requireNonNull(nodeIds);
            Objects.requireNonNull(foreignSources);
            Objects.requireNonNull(foreignIds);
            if (nodeIds.isEmpty() && foreignSources.isEmpty() && foreignIds.isEmpty()) {
                return Lists.newArrayList();
            }
            if (!nodeIds.isEmpty() && foreignSources.isEmpty() && foreignIds.isEmpty()) {
                return DefaultNodeService.this.accessor.findUsingNamedParameters("select n from OnmsNode n where n.id in (:nodeIds)", new String[]{"nodeIds"}, new Object[]{nodeIds});
            }
            if (nodeIds.isEmpty() && !foreignSources.isEmpty() && !foreignIds.isEmpty()) {
                return DefaultNodeService.this.accessor.findUsingNamedParameters("select n from OnmsNode n where n.foreignSource in (:foreignSources) and n.foreignId in (:foreignIds)", new String[]{"foreignSources", "foreignIds"}, new Object[]{foreignSources, foreignIds});
            }
            return DefaultNodeService.this.accessor.findUsingNamedParameters("select n from OnmsNode n where n.id in (:nodeIds) or (n.foreignSource in (:foreignSources) and n.foreignId in (:foreignIds))", new String[]{"nodeIds", "foreignSources", "foreignIds"}, new Object[]{nodeIds, foreignSources, foreignIds});
        }
    }
}

