/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.service;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.opennms.netmgt.graph.api.ImmutableGraphContainer;
import org.opennms.netmgt.graph.api.generic.GenericGraph;
import org.opennms.netmgt.graph.api.generic.GenericGraphContainer;
import org.opennms.netmgt.graph.api.info.GraphContainerInfo;
import org.opennms.netmgt.graph.api.info.GraphInfo;
import org.opennms.netmgt.graph.api.service.GraphContainerCache;
import org.opennms.netmgt.graph.api.service.GraphContainerProvider;
import org.opennms.netmgt.graph.api.service.GraphService;

public class CachingGraphService
implements GraphService,
GraphContainerCache {
    private final GraphService delegate;
    private final LoadingCache<String, ImmutableGraphContainer> cache;
    private final Map<String, Long> expireMap = new ConcurrentHashMap<String, Long>();

    public CachingGraphService(GraphService delegate) {
        this.delegate = Objects.requireNonNull(delegate);
        this.cache = Caffeine.newBuilder().expireAfter((Expiry)new Expiry<String, ImmutableGraphContainer>(){

            public long expireAfterCreate(String key, ImmutableGraphContainer value, long currentTime) {
                Long expireInMs = CachingGraphService.this.expireMap.getOrDefault(key, 9223372036854L);
                return expireInMs * 1000000L;
            }

            public long expireAfterUpdate(String key, ImmutableGraphContainer value, long currentTime, long currentDuration) {
                return currentDuration;
            }

            public long expireAfterRead(String key, ImmutableGraphContainer value, long currentTime, long currentDuration) {
                return currentDuration;
            }
        }).recordStats().build(arg_0 -> ((GraphService)delegate).getGraphContainer(arg_0));
    }

    public List<GraphContainerInfo> getGraphContainerInfos() {
        return this.delegate.getGraphContainerInfos();
    }

    public GraphContainerInfo getGraphContainerInfo(String containerId) {
        return this.delegate.getGraphContainerInfo(containerId);
    }

    public GraphContainerInfo getGraphContainerInfoByNamespace(String namespace) {
        return this.delegate.getGraphContainerInfoByNamespace(namespace);
    }

    public GraphInfo getGraphInfo(String graphNamespace) {
        return this.delegate.getGraphInfo(graphNamespace);
    }

    public GenericGraphContainer getGraphContainer(String containerId) {
        ImmutableGraphContainer immutableGraphContainer = this.get(containerId);
        if (immutableGraphContainer != null) {
            return immutableGraphContainer.asGenericGraphContainer();
        }
        return null;
    }

    public GenericGraph getGraph(String containerId, String graphNamespace) {
        GenericGraphContainer graphContainer = this.getGraphContainer(containerId);
        if (graphContainer != null) {
            return graphContainer.getGraph(graphNamespace);
        }
        return null;
    }

    public void invalidate(String containerId) {
        this.cache.invalidate((Object)containerId);
    }

    public ImmutableGraphContainer get(String containerId) {
        return (ImmutableGraphContainer)this.cache.get((Object)containerId);
    }

    public synchronized void onUnbind(GraphContainerProvider graphContainerProvider, Map<String, String> props) {
        if (graphContainerProvider != null) {
            String containerId = graphContainerProvider.getContainerInfo().getId();
            this.cache.invalidate((Object)containerId);
            this.expireMap.remove(containerId);
        }
    }

    public void onBind(GraphContainerProvider graphContainerProvider, Map<String, String> props) {
        String containerId = graphContainerProvider.getContainerInfo().getId();
        long cacheInvalidateIntervalInSeconds = Long.valueOf(props.getOrDefault("cacheInvalidateInterval", "0"));
        if (cacheInvalidateIntervalInSeconds > 0L) {
            long cacheInvalidateIntervalInMilliseconds = cacheInvalidateIntervalInSeconds * 1000L;
            this.expireMap.put(containerId, cacheInvalidateIntervalInMilliseconds);
        }
    }
}

