/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.search;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.netmgt.graph.api.generic.GenericGraph;
import org.opennms.netmgt.graph.api.generic.GenericVertex;
import org.opennms.netmgt.graph.api.search.SearchContext;
import org.opennms.netmgt.graph.api.search.SearchCriteria;
import org.opennms.netmgt.graph.api.search.SearchProvider;
import org.opennms.netmgt.graph.api.search.SearchSuggestion;
import org.opennms.netmgt.graph.api.service.GraphService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabelSearchProvider
implements SearchProvider {
    private static final Logger LOG = LoggerFactory.getLogger(LabelSearchProvider.class);

    public boolean canSuggest(GraphService graphService, String namespace) {
        return true;
    }

    public List<SearchSuggestion> getSuggestions(SearchContext searchContext, String namespace, String input) {
        Objects.requireNonNull(input);
        return this.getVerticesOfGraph(searchContext.getGraphService(), namespace).stream().filter(v -> v.getLabel() != null && v.getLabel().toLowerCase().contains(input.toLowerCase())).map(v -> new SearchSuggestion(this.getProviderId(), GenericVertex.class.getSimpleName(), v.getLabel(), v.getLabel())).limit(searchContext.getSuggestionsLimit()).collect(Collectors.toList());
    }

    public List<GenericVertex> resolve(GraphService graphService, SearchCriteria searchCriteria) {
        List<GenericVertex> vertices = this.getVerticesOfGraph(graphService, searchCriteria.getNamespace()).stream().filter(v -> v.getLabel() != null && v.getLabel().toLowerCase().contains(searchCriteria.getCriteria().toLowerCase())).collect(Collectors.toList());
        return vertices;
    }

    private List<GenericVertex> getVerticesOfGraph(GraphService graphService, String namespace) {
        List result;
        GenericGraph graph = graphService.getGraph(namespace);
        if (graph != null) {
            result = graph.getVertices();
        } else {
            LOG.warn("Could not find graph for namespace {}", (Object)namespace);
            result = Collections.emptyList();
        }
        return result;
    }
}

