/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.alarms.history.elastic.dto;

import com.google.common.collect.ImmutableMap;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opennms.features.alarms.history.api.AlarmState;
import org.opennms.features.alarms.history.elastic.dto.EventDocumentDTO;
import org.opennms.features.alarms.history.elastic.dto.MemoDocumentDTO;
import org.opennms.features.alarms.history.elastic.dto.MonitoringSystemDTO;
import org.opennms.features.alarms.history.elastic.dto.NodeDocumentDTO;
import org.opennms.features.alarms.history.elastic.dto.RelatedAlarmDocumentDTO;

public class AlarmDocumentDTO
implements AlarmState {
    private static final int DOCUMENT_VERSION = 1;
    @SerializedName(value="@deleted_time")
    private Long deletedTime;
    @SerializedName(value="@first_event_time")
    private Long firstEventTime;
    @SerializedName(value="@last_event_time")
    private Long lastEventTime;
    @SerializedName(value="@update_time")
    private Long updateTime;
    @SerializedName(value="@version")
    private Integer version = 1;
    @SerializedName(value="ack_time")
    private Long ackTime;
    @SerializedName(value="ack_user")
    private String ackUser;
    @SerializedName(value="application_dn")
    private String applicationDN;
    @SerializedName(value="archived")
    private Boolean archived;
    @SerializedName(value="archived_time")
    private Long archivedTime;
    @SerializedName(value="attributes")
    private Map<String, String> attributes = new HashMap<String, String>();
    @SerializedName(value="clear_key")
    private String clearKey;
    @SerializedName(value="counter")
    private Integer counter;
    @SerializedName(value="description")
    private String description;
    @SerializedName(value="dist_poller")
    private MonitoringSystemDTO distPoller;
    @SerializedName(value="first_automation_time")
    private Long firstAutomationTime;
    @SerializedName(value="id")
    private Integer id;
    @SerializedName(value="if_index")
    private Integer ifIndex;
    @SerializedName(value="ip_address")
    private String ipAddress;
    @SerializedName(value="journal_memo")
    private MemoDocumentDTO journalMemo;
    @SerializedName(value="last_automation_time")
    private Long lastAutomationTime;
    @SerializedName(value="last_event")
    private EventDocumentDTO lastEvent;
    @SerializedName(value="log_message")
    private String logMessage;
    @SerializedName(value="managed_object_instance")
    private String managedObjectInstance;
    @SerializedName(value="managed_object_type")
    private String managedObjectType;
    @SerializedName(value="mouse_over_text")
    private String mouseOverText;
    @SerializedName(value="node")
    private NodeDocumentDTO node;
    @SerializedName(value="operator_instructions")
    private String operatorInstructions;
    @SerializedName(value="oss_primary_key")
    private String ossPrimaryKey;
    @SerializedName(value="part_of_situation")
    private Boolean partOfSituation;
    @SerializedName(value="qos_alarm_state")
    private String qosAlarmState;
    @SerializedName(value="reduction_key")
    private String reductionKey;
    @SerializedName(value="related_alarm_count")
    private int relatedAlarmCount;
    @SerializedName(value="related_alarm_ids")
    private final Set<Integer> relatedAlarmIds = new HashSet<Integer>();
    @SerializedName(value="related_alarm_reduction_keys")
    private final List<String> relatedAlarmReductionKeys = new ArrayList<String>();
    @SerializedName(value="related_alarms")
    private List<RelatedAlarmDocumentDTO> relatedAlarms;
    @SerializedName(value="service_name")
    private String serviceName;
    @SerializedName(value="service_type")
    private String serviceType;
    @SerializedName(value="severity_id")
    private Integer severityId;
    @SerializedName(value="severity_label")
    private String severityLabel;
    @SerializedName(value="situation")
    private Boolean situation;
    @SerializedName(value="sticky_memo")
    private MemoDocumentDTO stickyMemo;
    @SerializedName(value="suppressed_time")
    private Long suppressedTime;
    @SerializedName(value="suppressed_until")
    private Long suppressedUntil;
    @SerializedName(value="suppressed_user")
    private String suppressedUser;
    @SerializedName(value="ticket_id")
    private String ticketId;
    @SerializedName(value="ticket_state_id")
    private Integer ticketStateId;
    @SerializedName(value="ticket_state_name")
    private String ticketStateName;
    @SerializedName(value="type")
    private Integer type;
    @SerializedName(value="x733_alarm_type")
    private String x733AlarmType;
    @SerializedName(value="x733_probable_cause")
    private Integer x733ProbableCause;

    public void addRelatedAlarm(RelatedAlarmDocumentDTO relatedAlarm) {
        if (this.relatedAlarms == null) {
            this.relatedAlarms = new LinkedList<RelatedAlarmDocumentDTO>();
        }
        this.relatedAlarms.add(Objects.requireNonNull(relatedAlarm));
        ++this.relatedAlarmCount;
        this.relatedAlarmIds.add(relatedAlarm.getId());
        this.relatedAlarmReductionKeys.add(relatedAlarm.getReductionKey());
    }

    public boolean isSituation() {
        return this.situation != null && this.situation != false;
    }

    public Long getDeletedTime() {
        return this.deletedTime;
    }

    public void setDeletedTime(Long deletedTime) {
        this.deletedTime = deletedTime;
    }

    public Long getFirstEventTime() {
        return this.firstEventTime;
    }

    public void setFirstEventTime(Long firstEventTime) {
        this.firstEventTime = firstEventTime;
    }

    public Long getLastEventTime() {
        return this.lastEventTime;
    }

    public void setLastEventTime(Long lastEventTime) {
        this.lastEventTime = lastEventTime;
    }

    public Long getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(Long updateTime) {
        this.updateTime = updateTime;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public Long getAckTime() {
        return this.ackTime;
    }

    public void setAckTime(Long ackTime) {
        this.ackTime = ackTime;
    }

    public String getAckUser() {
        return this.ackUser;
    }

    public void setAckUser(String ackUser) {
        this.ackUser = ackUser;
    }

    public String getApplicationDN() {
        return this.applicationDN;
    }

    public void setApplicationDN(String applicationDN) {
        this.applicationDN = applicationDN;
    }

    public Boolean getArchived() {
        return this.archived;
    }

    public void setArchived(Boolean archived) {
        this.archived = archived;
    }

    public Long getArchivedTime() {
        return this.archivedTime;
    }

    public void setArchivedTime(Long archivedTime) {
        this.archivedTime = archivedTime;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes == null ? null : ImmutableMap.copyOf(attributes);
    }

    public String getClearKey() {
        return this.clearKey;
    }

    public void setClearKey(String clearKey) {
        this.clearKey = clearKey;
    }

    public Integer getCounter() {
        return this.counter;
    }

    public void setCounter(Integer counter) {
        this.counter = counter;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public MonitoringSystemDTO getDistPoller() {
        return this.distPoller;
    }

    public void setDistPoller(MonitoringSystemDTO distPoller) {
        this.distPoller = distPoller;
    }

    public Long getFirstAutomationTime() {
        return this.firstAutomationTime;
    }

    public void setFirstAutomationTime(Long firstAutomationTime) {
        this.firstAutomationTime = firstAutomationTime;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getIfIndex() {
        return this.ifIndex;
    }

    public void setIfIndex(Integer ifIndex) {
        this.ifIndex = ifIndex;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public MemoDocumentDTO getJournalMemo() {
        return this.journalMemo;
    }

    public void setJournalMemo(MemoDocumentDTO journalMemo) {
        this.journalMemo = journalMemo;
    }

    public Long getLastAutomationTime() {
        return this.lastAutomationTime;
    }

    public void setLastAutomationTime(Long lastAutomationTime) {
        this.lastAutomationTime = lastAutomationTime;
    }

    public EventDocumentDTO getLastEvent() {
        return this.lastEvent;
    }

    public void setLastEvent(EventDocumentDTO lastEvent) {
        this.lastEvent = lastEvent;
    }

    public String getLogMessage() {
        return this.logMessage;
    }

    public void setLogMessage(String logMessage) {
        this.logMessage = logMessage;
    }

    public String getManagedObjectInstance() {
        return this.managedObjectInstance;
    }

    public void setManagedObjectInstance(String managedObjectInstance) {
        this.managedObjectInstance = managedObjectInstance;
    }

    public String getManagedObjectType() {
        return this.managedObjectType;
    }

    public void setManagedObjectType(String managedObjectType) {
        this.managedObjectType = managedObjectType;
    }

    public String getMouseOverText() {
        return this.mouseOverText;
    }

    public void setMouseOverText(String mouseOverText) {
        this.mouseOverText = mouseOverText;
    }

    public NodeDocumentDTO getNode() {
        return this.node;
    }

    public void setNode(NodeDocumentDTO node) {
        this.node = node;
    }

    public String getOperatorInstructions() {
        return this.operatorInstructions;
    }

    public void setOperatorInstructions(String operatorInstructions) {
        this.operatorInstructions = operatorInstructions;
    }

    public String getOssPrimaryKey() {
        return this.ossPrimaryKey;
    }

    public void setOssPrimaryKey(String ossPrimaryKey) {
        this.ossPrimaryKey = ossPrimaryKey;
    }

    public Boolean getPartOfSituation() {
        return this.partOfSituation;
    }

    public void setPartOfSituation(Boolean partOfSituation) {
        this.partOfSituation = partOfSituation;
    }

    public String getQosAlarmState() {
        return this.qosAlarmState;
    }

    public void setQosAlarmState(String qosAlarmState) {
        this.qosAlarmState = qosAlarmState;
    }

    public String getReductionKey() {
        return this.reductionKey;
    }

    public void setReductionKey(String reductionKey) {
        this.reductionKey = reductionKey;
    }

    public int getRelatedAlarmCount() {
        return this.relatedAlarmCount;
    }

    public Set<Integer> getRelatedAlarmIds() {
        return this.relatedAlarmIds;
    }

    public List<String> getRelatedAlarmReductionKeys() {
        return this.relatedAlarmReductionKeys;
    }

    public List<RelatedAlarmDocumentDTO> getRelatedAlarms() {
        return this.relatedAlarms;
    }

    public void setRelatedAlarms(List<RelatedAlarmDocumentDTO> relatedAlarms) {
        this.relatedAlarms = relatedAlarms;
        this.relatedAlarmCount = relatedAlarms.size();
        this.relatedAlarmIds.clear();
        this.relatedAlarmReductionKeys.clear();
        for (RelatedAlarmDocumentDTO relatedAlarm : relatedAlarms) {
            this.relatedAlarmIds.add(relatedAlarm.getId());
            this.relatedAlarmReductionKeys.add(relatedAlarm.getReductionKey());
        }
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public Integer getSeverityId() {
        return this.severityId;
    }

    public void setSeverityId(Integer severityId) {
        this.severityId = severityId;
    }

    public String getSeverityLabel() {
        return this.severityLabel;
    }

    public void setSeverityLabel(String severityLabel) {
        this.severityLabel = severityLabel;
    }

    public Boolean getSituation() {
        return this.situation;
    }

    public void setSituation(Boolean situation) {
        this.situation = situation;
    }

    public MemoDocumentDTO getStickyMemo() {
        return this.stickyMemo;
    }

    public void setStickyMemo(MemoDocumentDTO stickyMemo) {
        this.stickyMemo = stickyMemo;
    }

    public Long getSuppressedTime() {
        return this.suppressedTime;
    }

    public void setSuppressedTime(Long suppressedTime) {
        this.suppressedTime = suppressedTime;
    }

    public Long getSuppressedUntil() {
        return this.suppressedUntil;
    }

    public void setSuppressedUntil(Long suppressedUntil) {
        this.suppressedUntil = suppressedUntil;
    }

    public String getSuppressedUser() {
        return this.suppressedUser;
    }

    public void setSuppressedUser(String suppressedUser) {
        this.suppressedUser = suppressedUser;
    }

    public String getTicketId() {
        return this.ticketId;
    }

    public void setTicketId(String ticketId) {
        this.ticketId = ticketId;
    }

    public Integer getTicketStateId() {
        return this.ticketStateId;
    }

    public void setTicketStateId(Integer ticketStateId) {
        this.ticketStateId = ticketStateId;
    }

    public String getTicketStateName() {
        return this.ticketStateName;
    }

    public void setTicketStateName(String ticketStateName) {
        this.ticketStateName = ticketStateName;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getX733AlarmType() {
        return this.x733AlarmType;
    }

    public void setX733AlarmType(String x733AlarmType) {
        this.x733AlarmType = x733AlarmType;
    }

    public Integer getX733ProbableCause() {
        return this.x733ProbableCause;
    }

    public void setX733ProbableCause(Integer x733ProbableCause) {
        this.x733ProbableCause = x733ProbableCause;
    }

    public String toString() {
        return "AlarmDocumentDTO{deletedTime=" + this.deletedTime + ", firstEventTime=" + this.firstEventTime + ", lastEventTime=" + this.lastEventTime + ", updateTime=" + this.updateTime + ", version=" + this.version + ", ackTime=" + this.ackTime + ", ackUser='" + this.ackUser + "', applicationDN='" + this.applicationDN + "', archived=" + this.archived + ", archivedTime=" + this.archivedTime + ", attributes=" + String.valueOf(this.attributes) + ", clearKey='" + this.clearKey + "', counter=" + this.counter + ", description='" + this.description + "', distPoller=" + String.valueOf(this.distPoller) + ", firstAutomationTime=" + this.firstAutomationTime + ", id=" + this.id + ", ifIndex=" + this.ifIndex + ", ipAddress='" + this.ipAddress + "', journalMemo=" + String.valueOf(this.journalMemo) + ", lastAutomationTime=" + this.lastAutomationTime + ", lastEvent=" + String.valueOf(this.lastEvent) + ", logMessage='" + this.logMessage + "', managedObjectInstance='" + this.managedObjectInstance + "', managedObjectType='" + this.managedObjectType + "', mouseOverText='" + this.mouseOverText + "', node=" + String.valueOf(this.node) + ", operatorInstructions='" + this.operatorInstructions + "', ossPrimaryKey='" + this.ossPrimaryKey + "', partOfSituation=" + this.partOfSituation + ", qosAlarmState='" + this.qosAlarmState + "', reductionKey='" + this.reductionKey + "', relatedAlarmCount=" + this.relatedAlarmCount + ", relatedAlarmIds=" + String.valueOf(this.relatedAlarmIds) + ", relatedAlarmReductionKeys=" + String.valueOf(this.relatedAlarmReductionKeys) + ", relatedAlarms=" + String.valueOf(this.relatedAlarms) + ", serviceName='" + this.serviceName + "', serviceType='" + this.serviceType + "', severityId=" + this.severityId + ", severityLabel='" + this.severityLabel + "', situation=" + this.situation + ", stickyMemo=" + String.valueOf(this.stickyMemo) + ", suppressedTime=" + this.suppressedTime + ", suppressedUntil=" + this.suppressedUntil + ", suppressedUser='" + this.suppressedUser + "', ticketId='" + this.ticketId + "', ticketStateId=" + this.ticketStateId + ", ticketStateName='" + this.ticketStateName + "', type=" + this.type + ", x733AlarmType='" + this.x733AlarmType + "', x733ProbableCause=" + this.x733ProbableCause + "}";
    }
}

