/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model.alarm;

import java.io.Serializable;
import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.opennms.core.utils.FuzzyDateFormatter;
import org.opennms.netmgt.model.OnmsSeverity;

@XmlRootElement(name="alarm-summary")
@XmlAccessorType(value=XmlAccessType.NONE)
public class AlarmSummary
implements Comparable<AlarmSummary>,
Serializable {
    private static final long serialVersionUID = 1L;
    @XmlAttribute(name="node-id")
    private int nodeId;
    @XmlAttribute(name="node-label")
    private String nodeLabel;
    @XmlAttribute(name="date")
    private Date minLastEventDate;
    @XmlAttribute(name="severity")
    private OnmsSeverity maxSeverity;
    @XmlAttribute(name="count")
    private long alarmCount;

    public AlarmSummary() {
    }

    public AlarmSummary(Integer nodeId, String nodeLabel, Date minLastEventDate, OnmsSeverity maxSeverity, Long alarmCount) {
        this.nodeId = nodeId;
        this.nodeLabel = nodeLabel == null ? String.valueOf(nodeId) : nodeLabel;
        this.minLastEventDate = minLastEventDate;
        this.maxSeverity = maxSeverity;
        this.alarmCount = alarmCount;
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public String getNodeLabel() {
        return this.nodeLabel;
    }

    public Date getMinLastEventDate() {
        return this.minLastEventDate;
    }

    public long getAlarmCount() {
        return this.alarmCount;
    }

    public OnmsSeverity getMaxSeverity() {
        return this.maxSeverity;
    }

    public String getFuzzyTimeDown() {
        return this.minLastEventDate == null ? "N/A" : FuzzyDateFormatter.calculateDifference((Date)this.minLastEventDate, (Date)new Date());
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[AlarmSummary: ");
        buffer.append(this.nodeId);
        buffer.append(":");
        buffer.append(this.nodeLabel);
        buffer.append(" has ");
        buffer.append(this.alarmCount);
        buffer.append(" alarms since ");
        buffer.append(this.minLastEventDate);
        buffer.append("]");
        return buffer.toString();
    }

    @Override
    public int compareTo(AlarmSummary that) {
        return new CompareToBuilder().append((Object)this.getMinLastEventDate(), (Object)that.getMinLastEventDate()).append((Object)this.getNodeLabel(), (Object)that.getNodeLabel()).toComparison();
    }
}

