/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.datachoices.internal.productupdateenrollment;

import java.io.IOException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.opennms.features.datachoices.internal.productupdateenrollment.ProductUpdateEnrollmentFormData;
import org.opennms.features.datachoices.internal.productupdateenrollment.ProductUpdateEnrollmentService;
import org.opennms.features.datachoices.internal.productupdateenrollment.ProductUpdateEnrollmentSubmissionClient;
import org.opennms.features.datachoices.internal.productupdateenrollment.ProductUpdateEnrollmentSubmissionData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProductUpdateEnrollmentServiceImpl
implements ProductUpdateEnrollmentService {
    private static final Logger LOG = LoggerFactory.getLogger(ProductUpdateEnrollmentServiceImpl.class);
    private ProductUpdateEnrollmentSubmissionClient client;

    @Override
    public void submit(ProductUpdateEnrollmentFormData data) throws Exception, IOException {
        ProductUpdateEnrollmentSubmissionData submissionData = this.createSubmissionData(data);
        String json = this.jsonSerialize(submissionData);
        this.client.postForm(json);
    }

    private ProductUpdateEnrollmentSubmissionData createSubmissionData(ProductUpdateEnrollmentFormData data) {
        ProductUpdateEnrollmentSubmissionData submissionData = new ProductUpdateEnrollmentSubmissionData();
        submissionData.consent = true;
        submissionData.firstName = data.firstName;
        submissionData.lastName = data.lastName;
        submissionData.email = data.email;
        submissionData.company = data.company;
        submissionData.product = "Horizon";
        submissionData.systemId = "";
        return submissionData;
    }

    private String jsonSerialize(ProductUpdateEnrollmentSubmissionData data) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(new SerializationConfig.Feature[]{SerializationConfig.Feature.SORT_PROPERTIES_ALPHABETICALLY});
        mapper.enable(new SerializationConfig.Feature[]{SerializationConfig.Feature.INDENT_OUTPUT});
        try {
            return mapper.writeValueAsString((Object)data);
        }
        catch (IOException e) {
            LOG.error("Error serializing submission Json data", (Throwable)e);
            throw e;
        }
    }

    public void setClient(ProductUpdateEnrollmentSubmissionClient client) {
        this.client = client;
    }
}

