/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.config.osgi.cm;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Objects;
import java.util.Properties;
import org.json.JSONObject;
import org.opennms.features.config.osgi.cm.CmPersistenceManager;
import org.opennms.features.config.service.api.JsonAsString;

public class DictionaryUtil {
    public static Dictionary createFromJson(JsonAsString json) {
        Objects.requireNonNull(json);
        Properties props = new Properties();
        new JSONObject(json.toString()).toMap().entrySet().stream().filter(e -> e.getValue() != null).forEach(e -> props.put(e.getKey(), e.getValue()));
        return props;
    }

    public static JsonAsString writeToJson(Dictionary dictionary) {
        Objects.requireNonNull(dictionary);
        JSONObject json = new JSONObject();
        Enumeration keys = dictionary.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = dictionary.get(key);
            if (CmPersistenceManager.OSGI_PROPERTIES.contains(key.toString())) continue;
            json.put(key.toString(), value);
        }
        return new JsonAsString(json.toString());
    }
}

