/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.config.osgi.cm;

import java.io.IOException;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.felix.cm.PersistenceManager;
import org.opennms.features.config.osgi.cm.CmIdentifierUtil;
import org.opennms.features.config.osgi.cm.DictionaryUtil;
import org.opennms.features.config.osgi.del.MigratedServices;
import org.opennms.features.config.service.api.ConfigUpdateInfo;
import org.opennms.features.config.service.api.ConfigurationManagerService;
import org.opennms.features.config.service.api.JsonAsString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmPersistenceManager
implements PersistenceManager {
    private static final Logger LOG = LoggerFactory.getLogger(CmPersistenceManager.class);
    public static final Set<String> OSGI_PROPERTIES = Set.of(":org.apache.felix.configadmin.revision:", "service.bundleLocation", "service.factoryPid", "service.pid");
    private final ConfigurationManagerService configService;
    private final Map<String, String> osgiPidToCmPid = new ConcurrentHashMap<String, String>();
    private final Map<String, String> cmPidToOsgiPid = new ConcurrentHashMap<String, String>();

    public CmPersistenceManager(ConfigurationManagerService configService) {
        this.configService = configService;
    }

    public boolean exists(String pid) {
        return MigratedServices.isMigrated((String)pid) && this.loadInternal(pid).isPresent();
    }

    public Enumeration getDictionaries() {
        HashSet pids = new HashSet();
        for (String configName : MigratedServices.PIDS_MULTI_INSTANCE) {
            Set configIds = this.configService.getConfigIds(configName);
            configIds.stream().map(id -> configName + "-" + id).forEach(pids::add);
        }
        pids.addAll(MigratedServices.PIDS_SINGLE_INSTANCE);
        List dictionaries = pids.stream().map(this::loadInternal).flatMap(Optional::stream).collect(Collectors.toList());
        return Collections.enumeration(dictionaries);
    }

    public Dictionary load(String pid) {
        return this.loadInternal(pid).orElse(new Hashtable());
    }

    private Optional<Dictionary<String, Object>> loadInternal(String osgiPid) {
        Objects.requireNonNull(osgiPid);
        String cmPid = this.getCmPid(osgiPid);
        ConfigUpdateInfo identifier = CmIdentifierUtil.pidToCmIdentifier(cmPid);
        return this.configService.getJSONStrConfiguration(identifier).map(s -> {
            Dictionary d = DictionaryUtil.createFromJson(new JsonAsString(s));
            if (d.get("service.pid") == null) {
                d.put("service.pid", osgiPid);
            }
            if (MigratedServices.isMultiInstanceService((String)cmPid) && d.get("service.factoryPid") == null) {
                d.put("service.factoryPid", identifier.getConfigName());
            }
            return d;
        });
    }

    public void store(String osgiPid, Dictionary props) throws IOException {
        Optional<Dictionary<String, Object>> confFromConfigService = this.loadInternal(osgiPid);
        if (confFromConfigService.isEmpty() || !CmPersistenceManager.equalsWithoutOsgiProperties(props, confFromConfigService.get())) {
            ConfigUpdateInfo identifier = CmIdentifierUtil.pidToCmIdentifier(this.getCmPid(osgiPid));
            this.configService.updateConfiguration(identifier.getConfigName(), identifier.getConfigId(), new JsonAsString(DictionaryUtil.writeToJson(props).toString()), false);
        }
    }

    public void delete(String pid) throws IOException {
        LOG.warn("Deletion of pid={} not supported.", (Object)pid);
    }

    void setPidMapping(String osgiPid, String cmPid) {
        this.osgiPidToCmPid.put(osgiPid, cmPid);
        this.cmPidToOsgiPid.put(cmPid, osgiPid);
    }

    String getCmPid(String osgiPid) {
        return this.osgiPidToCmPid.getOrDefault(osgiPid, osgiPid);
    }

    String getOsgiPid(ConfigUpdateInfo key) {
        String cmPid = CmIdentifierUtil.cmIdentifierToPid(key);
        return this.cmPidToOsgiPid.getOrDefault(cmPid, cmPid);
    }

    public static boolean equalsWithoutOsgiProperties(Dictionary<String, Object> a, Dictionary<String, Object> b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return Collections.list(a.keys()).stream().filter(key -> !OSGI_PROPERTIES.contains(key)).allMatch(key -> a.get(key).equals(b.get(key)));
    }
}

