/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.config.osgi.cm;

import java.util.Hashtable;
import java.util.Optional;
import org.apache.felix.cm.PersistenceManager;
import org.opennms.features.config.osgi.cm.CallbackManager;
import org.opennms.features.config.osgi.cm.CmPersistenceManager;
import org.opennms.features.config.service.api.ConfigurationManagerService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static final Logger LOG = LoggerFactory.getLogger(Activator.class);
    private ServiceRegistration<PersistenceManager> registration;

    public void start(BundleContext context) {
        Hashtable<String, String> config = new Hashtable<String, String>();
        config.put("name", CmPersistenceManager.class.getName());
        LOG.info("Registering service {}.", (Object)CmPersistenceManager.class.getSimpleName());
        ConfigurationManagerService cm = this.findService(context, ConfigurationManagerService.class);
        CmPersistenceManager persistenceManager = new CmPersistenceManager(cm);
        this.registration = context.registerService(PersistenceManager.class, (Object)persistenceManager, config);
        ConfigurationAdmin configurationAdmin = this.findService(context, ConfigurationAdmin.class);
        new CallbackManager().registerCallbacks(configurationAdmin, cm, persistenceManager);
        LOG.info("{} started.", (Object)CmPersistenceManager.class.getSimpleName());
    }

    private <T> T findService(BundleContext context, Class<T> clazz) {
        return (T)Optional.ofNullable(context.getServiceReference(clazz)).map(arg_0 -> ((BundleContext)context).getService(arg_0)).orElseThrow(() -> new IllegalStateException("Cannot find " + clazz.getName()));
    }

    public void stop(BundleContext context) {
        if (this.registration != null) {
            this.registration.unregister();
        }
        LOG.info("{} stopped.", (Object)CmPersistenceManager.class.getSimpleName());
    }
}

