/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.systemreport.system;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.opennms.core.resource.Vault;
import org.opennms.systemreport.AbstractSystemReportPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class OSReportPlugin
extends AbstractSystemReportPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(OSReportPlugin.class);
    private static final Map<String, String> m_oses = new LinkedHashMap<String, String>();
    private static final MBeanServer M_BEAN_SERVER = ManagementFactory.getPlatformMBeanServer();
    private static final String JMX_OBJ_OS = "java.lang:type=OperatingSystem";
    private static final String JMX_ATTR_AVAILABLE_PROCESSORS = "AvailableProcessors";
    private static final String JMX_ATTR_FREE_PHYSICAL_MEMORY_SIZE = "FreePhysicalMemorySize";
    private static final String JMX_ATTR_TOTAL_PHYSICAL_MEMORY_SIZE = "TotalPhysicalMemorySize";

    public OSReportPlugin() {
        if (m_oses.size() == 0) {
            m_oses.put("/etc/SUSE-release", "SuSE");
            m_oses.put("/etc/redhat-release", "Red Hat");
            m_oses.put("/etc/fedora-release", "Fedora");
            m_oses.put("/etc/slackware-release", "Slackware");
            m_oses.put("/etc/debian_version", "Debian");
            m_oses.put("/etc/debian_release", "Debian");
            m_oses.put("/etc/mandriva-release", "Mandriva");
            m_oses.put("/etc/mandrake-release", "Mandrake");
            m_oses.put("/etc/mandrakelinux-release", "Mandrake");
            m_oses.put("/etc/yellowdog-release", "Yellow Dog");
            m_oses.put("/etc/sun-release", "Java Desktop System");
            m_oses.put("/etc/gentoo-release", "Gentoo");
            m_oses.put("/etc/UnitedLinux-release", "UnitedLinux");
        }
    }

    @Override
    public String getName() {
        return "OS";
    }

    @Override
    public String getDescription() {
        return "Kernel, OS, and Distribution";
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public int getPriority() {
        return 2;
    }

    @Override
    public Map<String, Resource> getEntries() {
        TreeMap<String, Resource> map = new TreeMap<String, Resource>();
        map.put("Name", this.getResourceFromProperty("os.name"));
        map.put("Architecture", this.getResourceFromProperty("os.arch"));
        map.put("Version", this.getResourceFromProperty("os.version"));
        map.put("Distribution", (Resource)map.get("Name"));
        OperatingSystemMXBean osBean = this.getBean(JMX_OBJ_OS, OperatingSystemMXBean.class);
        if (osBean == null) {
            LOG.info("falling back to local VM OperatingSystemMXBean");
            osBean = ManagementFactory.getOperatingSystemMXBean();
        }
        LOG.trace("bean = {}", (Object)osBean);
        this.addGetters(osBean, map);
        File lsb = new File("/bin/lsb_release");
        File solaris = new File("/var/sadm/softinfo/INST_RELEASE");
        if (lsb.exists()) {
            String text = this.slurpCommand(new String[]{"/bin/lsb_release", "-a"});
            distMap = this.splitMultilineString(": +", text);
            for (Map.Entry<String, String> entry : distMap.entrySet()) {
                map.put("Distribution " + entry.getKey(), this.getResource(entry.getValue()));
            }
        } else if (solaris.exists()) {
            String arch;
            File isainfo;
            map.put("Distribution OS", this.getResource("Solaris"));
            String solarisText = this.slurp(solaris);
            distMap = this.splitMultilineString("=", solarisText);
            for (Map.Entry<String, String> entry : distMap.entrySet()) {
                map.put("Distribution " + entry.getKey().toLowerCase().replaceFirst("^.", entry.getKey().substring(0, 1).toUpperCase()), this.getResource(entry.getValue()));
            }
            if (map.containsKey("Distribution OS")) {
                map.put("Distribution", (Resource)map.remove("Distribution OS"));
            }
            if ((isainfo = new File("/usr/bin/isainfo")).exists() && (arch = this.slurpCommand(new String[]{"/usr/bin/isainfo", "-n"})) != null) {
                map.put("Instruction Set", this.getResource(arch));
            }
        } else {
            for (Map.Entry<String, String> entry : m_oses.entrySet()) {
                String description = this.slurp(new File(entry.getKey()));
                if (description == null) continue;
                map.put("Distribution", this.getResource(entry.getValue()));
                map.put("Description", this.getResource(description.trim()));
            }
        }
        if (map.containsKey("Distribution Distributor ID")) {
            map.put("Distribution", (Resource)map.remove("Distribution Distributor ID"));
        }
        if (map.containsKey("Distribution Description")) {
            map.put("Description", (Resource)map.remove("Distribution Description"));
        }
        map.put("HTTP(S) ports", this.getResource(Vault.getProperty((String)"org.opennms.netmgt.jetty.port")));
        Object availableProcessorsObj = this.getJmxAttribute(JMX_OBJ_OS, JMX_ATTR_AVAILABLE_PROCESSORS);
        if (availableProcessorsObj != null) {
            map.put("System CPU count", this.getResource(String.valueOf((Integer)availableProcessorsObj)));
        }
        long totalPhysicalMemSize = 0L;
        Object totalPhysicalMemSizeObj = this.getJmxAttribute(JMX_OBJ_OS, JMX_ATTR_TOTAL_PHYSICAL_MEMORY_SIZE);
        if (totalPhysicalMemSizeObj != null) {
            totalPhysicalMemSize = (Long)totalPhysicalMemSizeObj;
        }
        long freePhysicalMemSize = 0L;
        Object freePhysicalMemSizeObj = this.getJmxAttribute(JMX_OBJ_OS, JMX_ATTR_FREE_PHYSICAL_MEMORY_SIZE);
        if (freePhysicalMemSizeObj != null) {
            freePhysicalMemSize = (Long)freePhysicalMemSizeObj;
        }
        map.put("Total System RAM", this.getResource(String.valueOf(totalPhysicalMemSize)));
        map.put("Used System RAM", this.getResource(String.valueOf(totalPhysicalMemSize - freePhysicalMemSize)));
        return map;
    }

    private Object getJmxAttribute(String objectName, String attributeName) {
        ObjectName objNameActual;
        try {
            objNameActual = new ObjectName(objectName);
        }
        catch (MalformedObjectNameException e) {
            LOG.warn("Failed to query from object name " + objectName, (Throwable)e);
            return null;
        }
        try {
            return M_BEAN_SERVER.getAttribute(objNameActual, attributeName);
        }
        catch (AttributeNotFoundException | InstanceNotFoundException | MBeanException | ReflectionException e) {
            LOG.warn("Failed to query from attribute name " + attributeName + " on object " + objectName, (Throwable)e);
            return null;
        }
    }
}

