/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.wsman.cxf;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.binding.soap.interceptor.SoapPreProtocolOutInterceptor;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.headers.Header;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxb.JAXBDataBinding;
import schemas.dmtf.org.wbem.wsman.v1.AttributableURI;
import schemas.dmtf.org.wbem.wsman.v1.ObjectFactory;
import schemas.dmtf.org.wbem.wsman.v1.SelectorSetType;
import schemas.dmtf.org.wbem.wsman.v1.SelectorType;

public class WSManHeaderInterceptor
extends AbstractSoapInterceptor {
    private static final JAXBDataBinding ATTRIBUTABLE_URI_JAXB_DATA_BINDING;
    private final String m_resourceUri;
    private final Map<String, String> m_selectors;
    private final ObjectFactory factory = new ObjectFactory();

    public WSManHeaderInterceptor(String resourceUri) {
        this(resourceUri, Collections.emptyMap());
    }

    public WSManHeaderInterceptor(String resourceUri, Map<String, String> selectors) {
        super("post-logical");
        this.addAfter(SoapPreProtocolOutInterceptor.class.getName());
        this.m_resourceUri = Objects.requireNonNull(resourceUri, "resourceUri cannot be null");
        this.m_selectors = Objects.requireNonNull(selectors, "selector cannot be null");
    }

    public void handleMessage(SoapMessage message) throws Fault {
        List headers = message.getHeaders();
        headers.add(this.getResourceUriHeader());
        if (!this.m_selectors.isEmpty()) {
            headers.add(this.getSelectorSetHeader());
        }
        message.put(Header.HEADER_LIST, (Object)headers);
    }

    private Header getResourceUriHeader() {
        AttributableURI uri = new AttributableURI();
        uri.setValue(this.m_resourceUri);
        JAXBElement<AttributableURI> resourceURI = this.factory.createResourceURI(uri);
        return new Header(resourceURI.getName(), resourceURI, (DataBinding)ATTRIBUTABLE_URI_JAXB_DATA_BINDING);
    }

    private Header getSelectorSetHeader() {
        SelectorSetType selectorSetType = this.factory.createSelectorSetType();
        for (Map.Entry<String, String> selectorEntry : this.m_selectors.entrySet()) {
            SelectorType selector = this.factory.createSelectorType();
            selector.setName(selectorEntry.getKey());
            selector.getContent().add((Serializable)((Object)selectorEntry.getValue()));
            selectorSetType.getSelector().add(selector);
        }
        JAXBElement<SelectorSetType> el = this.factory.createSelectorSet(selectorSetType);
        try {
            return new Header(el.getName(), el, (DataBinding)new JAXBDataBinding(new Class[]{((SelectorSetType)el.getValue()).getClass()}));
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            ATTRIBUTABLE_URI_JAXB_DATA_BINDING = new JAXBDataBinding(new Class[]{AttributableURI.class});
        }
        catch (JAXBException e) {
            throw new RuntimeException("Failed to create JAXBDataBinding for: " + AttributableURI.class, e);
        }
    }
}

