/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.profile.command;

import org.apache.karaf.profile.Profile;
import org.apache.karaf.profile.ProfileBuilder;
import org.apache.karaf.profile.ProfileService;
import org.apache.karaf.profile.command.completers.ProfileCompleter;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(name="copy", scope="profile", description="Copies the specified source profile")
@Service
public class ProfileCopy
implements Action {
    @Option(name="-f", aliases={"--force"}, description="Flag to allow overwriting the target profile (if exists).")
    private boolean force;
    @Argument(index=0, required=true, name="source profile", description="Name of the source profile.")
    @Completion(value=ProfileCompleter.class)
    private String source;
    @Argument(index=1, required=true, name="target profile", description="Name of the target profile.")
    private String target;
    @Reference
    private ProfileService profileService;

    public Object execute() throws Exception {
        Profile profile = ProfileBuilder.Factory.createFrom(this.profileService.getProfile(this.source)).identity(this.target).getProfile();
        this.profileService.createProfile(profile);
        return null;
    }
}

