/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.enlinkd.generator.protocol;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.opennms.enlinkd.generator.TopologyContext;
import org.opennms.enlinkd.generator.TopologyGenerator;
import org.opennms.enlinkd.generator.TopologySettings;
import org.opennms.enlinkd.generator.protocol.Protocol;
import org.opennms.enlinkd.generator.topology.PairGenerator;
import org.opennms.netmgt.enlinkd.model.IsIsElement;
import org.opennms.netmgt.enlinkd.model.IsIsLink;
import org.opennms.netmgt.model.OnmsNode;

public class IsIsProtocol
extends Protocol {
    private final TopologyGenerator.Protocol protocol = TopologyGenerator.Protocol.isis;

    public IsIsProtocol(TopologySettings topologySettings, TopologyContext context) {
        super(topologySettings, context);
    }

    @Override
    public void createAndPersistProtocolSpecificEntities(List<OnmsNode> nodes) {
        List<IsIsElement> elements = this.createElements(nodes);
        this.context.getTopologyPersister().persist(elements);
        List<IsIsLink> links = this.createLinks(elements);
        this.context.getTopologyPersister().persist(links);
    }

    private List<IsIsElement> createElements(List<OnmsNode> nodes) {
        ArrayList<IsIsElement> elements = new ArrayList<IsIsElement>();
        for (int i = 0; i < this.topologySettings.getAmountElements(); ++i) {
            OnmsNode node = nodes.get(i);
            elements.add(this.createElement(node));
        }
        return elements;
    }

    private IsIsElement createElement(OnmsNode node) {
        IsIsElement element = new IsIsElement();
        element.setNode(node);
        element.setIsisSysID("IsIsElementForNode" + node.getId());
        element.setIsisSysAdminState(IsIsElement.IsisAdminState.on);
        element.setIsisNodeLastPollTime(new Date());
        return element;
    }

    private List<IsIsLink> createLinks(List<IsIsElement> elements) {
        PairGenerator<IsIsElement> pairs = this.createPairGenerator(elements);
        ArrayList<IsIsLink> links = new ArrayList<IsIsLink>();
        Integer isisISAdjIndex = 0;
        for (int i = 0; i < this.topologySettings.getAmountLinks() / 2; ++i) {
            Pair<IsIsElement, IsIsElement> pair = pairs.next();
            IsIsElement sourceElement = (IsIsElement)pair.getLeft();
            IsIsElement targetElement = (IsIsElement)pair.getRight();
            Integer n = isisISAdjIndex;
            isisISAdjIndex = isisISAdjIndex + 1;
            int sourceIfIndex = (Integer)this.nodeIfIndexes.get(sourceElement.getNode().getId());
            int targetIfIndex = (Integer)this.nodeIfIndexes.get(targetElement.getNode().getId());
            IsIsLink sourceLink = this.createLink(sourceElement.getNode(), isisISAdjIndex, targetElement.getIsisSysID(), sourceIfIndex);
            links.add(sourceLink);
            IsIsLink targetLink = this.createLink(targetElement.getNode(), isisISAdjIndex, sourceElement.getIsisSysID(), targetIfIndex);
            links.add(targetLink);
            this.context.currentProgress(String.format("Linked node %s with node %s", sourceElement.getNode().getLabel(), targetElement.getNode().getLabel()));
        }
        return links;
    }

    private IsIsLink createLink(OnmsNode node, Integer isisISAdjIndex, String isisISAdjNeighSysID, int ifIndex) {
        IsIsLink link = new IsIsLink();
        link.setIsisISAdjIndex(isisISAdjIndex);
        link.setIsisISAdjNeighSysID(isisISAdjNeighSysID);
        link.setNode(node);
        link.setIsisLinkLastPollTime(new Date());
        link.setIsisCircIndex(Integer.valueOf(3));
        link.setIsisISAdjState(IsIsLink.IsisISAdjState.up);
        link.setIsisISAdjNeighSNPAAddress("isisISAdjNeighSNPAAddress");
        link.setIsisISAdjNeighSysType(IsIsLink.IsisISAdjNeighSysType.l1_IntermediateSystem);
        link.setIsisISAdjNbrExtendedCircID(Integer.valueOf(3));
        link.setIsisCircIfIndex(Integer.valueOf(ifIndex));
        link.setIsisCircAdminState(IsIsElement.IsisAdminState.on);
        return link;
    }

    @Override
    public TopologyGenerator.Protocol getProtocol() {
        return this.protocol;
    }
}

