/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.enlinkd.generator;

import org.opennms.enlinkd.generator.TopologyGenerator;

public class TopologySettings {
    private final int amountNodes;
    private final int amountElements;
    private final int amountLinks;
    private final int amountSnmpInterfaces;
    private final int amountIpInterfaces;
    private final TopologyGenerator.Topology topology;
    private final TopologyGenerator.Protocol protocol;

    private TopologySettings(Integer amountNodes, Integer amountElements, Integer amountLinks, Integer amountSnmpInterfaces, Integer amountIpInterfaces, TopologyGenerator.Topology topology, TopologyGenerator.Protocol protocol) {
        this.amountNodes = this.setToDefaultIfNotSet(amountNodes, 10);
        this.amountElements = this.setToDefaultIfNotSet(amountElements, this.amountNodes);
        this.amountLinks = this.setToDefaultIfNotSet(amountLinks, this.amountElements);
        this.amountSnmpInterfaces = this.setToDefaultIfNotSet(amountSnmpInterfaces, this.amountNodes * 18);
        this.amountIpInterfaces = this.setToDefaultIfNotSet(amountIpInterfaces, this.amountNodes * 2);
        this.topology = this.setToDefaultIfNotSet(topology, TopologyGenerator.Topology.random);
        this.protocol = this.setToDefaultIfNotSet(protocol, TopologyGenerator.Protocol.cdp);
    }

    private <T> T setToDefaultIfNotSet(T value, T defaultValue) {
        return value == null ? defaultValue : value;
    }

    public void verify() {
        TopologySettings.assertMoreOrEqualsThan("we need at least as many nodes as elements", this.amountElements, this.amountNodes);
        TopologySettings.assertMoreOrEqualsThan("we need at least 2 nodes", 2, this.amountNodes);
        TopologySettings.assertMoreOrEqualsThan("we need at least 2 elements", 2, this.amountElements);
        TopologySettings.assertMoreOrEqualsThan("we need at least 1 link", 1, this.amountLinks);
        TopologySettings.assertMoreOrEqualsThan("links must be less than or equal to number of snmp interfaces", this.amountLinks, this.amountSnmpInterfaces);
    }

    private static void assertMoreOrEqualsThan(String message, int expected, int actual) {
        if (actual < expected) {
            throw new IllegalArgumentException(message + String.format(" minimum expected=%s but found actual=%s", expected, actual));
        }
    }

    public int getAmountNodes() {
        return this.amountNodes;
    }

    public int getAmountElements() {
        return this.amountElements;
    }

    public int getAmountLinks() {
        return this.amountLinks;
    }

    public int getAmountSnmpInterfaces() {
        return this.amountSnmpInterfaces;
    }

    public int getAmountIpInterfaces() {
        return this.amountIpInterfaces;
    }

    public TopologyGenerator.Topology getTopology() {
        return this.topology;
    }

    public TopologyGenerator.Protocol getProtocol() {
        return this.protocol;
    }

    public static TopologySettingsBuilder builder() {
        return new TopologySettingsBuilder();
    }

    public static class TopologySettingsBuilder {
        private Integer amountNodes;
        private Integer amountElements;
        private Integer amountLinks;
        private Integer amountSnmpInterfaces;
        private Integer amountIpInterfaces;
        private TopologyGenerator.Topology topology;
        private TopologyGenerator.Protocol protocol;

        private TopologySettingsBuilder() {
        }

        public TopologySettingsBuilder amountNodes(Integer amountNodes) {
            this.amountNodes = amountNodes;
            return this;
        }

        public TopologySettingsBuilder amountElements(Integer amountElements) {
            this.amountElements = amountElements;
            return this;
        }

        public TopologySettingsBuilder amountLinks(Integer amountLinks) {
            this.amountLinks = amountLinks;
            return this;
        }

        public TopologySettingsBuilder amountSnmpInterfaces(Integer amountSnmpInterfaces) {
            this.amountSnmpInterfaces = amountSnmpInterfaces;
            return this;
        }

        public TopologySettingsBuilder amountIpInterfaces(Integer amountIpInterfaces) {
            this.amountIpInterfaces = amountIpInterfaces;
            return this;
        }

        public TopologySettingsBuilder topology(TopologyGenerator.Topology topology) {
            this.topology = topology;
            return this;
        }

        public TopologySettingsBuilder protocol(TopologyGenerator.Protocol protocol) {
            this.protocol = protocol;
            return this;
        }

        public TopologySettings build() {
            return new TopologySettings(this.amountNodes, this.amountElements, this.amountLinks, this.amountSnmpInterfaces, this.amountIpInterfaces, this.topology, this.protocol);
        }
    }
}

