/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.model;

import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Map;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.PrefabGraph;
import org.opennms.netmgt.model.RrdGraphAttribute;

public class Graph
implements Comparable<Graph> {
    private PrefabGraph m_graph = null;
    private OnmsResource m_resource;
    private Date m_start = null;
    private Date m_end = null;

    public Graph(PrefabGraph graph, OnmsResource resource, Date start, Date end) {
        this.m_graph = graph;
        this.m_resource = resource;
        this.m_start = start;
        this.m_end = end;
    }

    public OnmsResource getResource() {
        return this.m_resource;
    }

    public Date getStart() {
        return this.m_start;
    }

    public Date getEnd() {
        return this.m_end;
    }

    public String getName() {
        return this.m_graph.getName();
    }

    public String getTitle() {
        return this.m_graph.getTitle();
    }

    @Override
    public int compareTo(Graph other) {
        if (other == null) {
            return -1;
        }
        return this.m_graph.compareTo(other.m_graph);
    }

    public Integer getGraphWidth() {
        return this.m_graph.getGraphWidth();
    }

    public Integer getGraphHeight() {
        return this.m_graph.getGraphHeight();
    }

    public PrefabGraph getPrefabGraph() {
        return this.m_graph;
    }

    public String getReport() {
        return this.m_graph.getName();
    }

    public Collection<RrdGraphAttribute> getRequiredRrGraphdAttributes() {
        Map available = this.m_resource.getRrdGraphAttributes();
        LinkedHashSet<RrdGraphAttribute> reqAttrs = new LinkedHashSet<RrdGraphAttribute>();
        for (String attrName : this.m_graph.getColumns()) {
            RrdGraphAttribute attr = (RrdGraphAttribute)available.get(attrName);
            if (attr == null) continue;
            reqAttrs.add(attr);
        }
        return reqAttrs;
    }
}

