/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.shell.completer;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.CommandLine;
import org.apache.karaf.shell.api.console.Completer;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.support.completers.StringsCompleter;
import org.opennms.netmgt.graph.api.search.GraphSearchService;
import org.opennms.netmgt.graph.api.search.SearchSuggestion;
import org.opennms.netmgt.graph.shell.completer.CommandLineUtils;

@Service
public class SuggestionCompleter
implements Completer {
    @Reference
    private GraphSearchService graphSearchService;

    public int complete(Session session, CommandLine commandLine, List<String> candidates) {
        String currentSearch = commandLine.getCursorArgument();
        String namespace = this.extractNamespace(Lists.newArrayList((Object[])commandLine.getArguments()));
        StringsCompleter delegate = new StringsCompleter();
        if (currentSearch != null && currentSearch.length() > 0 && namespace.length() > 0) {
            List searchSuggestions = this.graphSearchService.getSuggestions(namespace, currentSearch);
            for (SearchSuggestion suggestion : searchSuggestions) {
                String label = suggestion.getLabel().replace(" ", "_");
                delegate.getStrings().add(label);
            }
        }
        return delegate.complete(session, commandLine, candidates);
    }

    protected String extractNamespace(List<String> arguments) {
        String namespace = CommandLineUtils.extractArgument(arguments, "--namespace");
        if (namespace == null) {
            return "";
        }
        return namespace;
    }
}

