/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.shell.completer;

import java.util.List;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.CommandLine;
import org.apache.karaf.shell.api.console.Completer;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.support.completers.StringsCompleter;
import org.opennms.netmgt.graph.api.info.GraphContainerInfo;
import org.opennms.netmgt.graph.api.service.GraphService;
import org.opennms.netmgt.graph.shell.completer.CommandLineUtils;
import org.opennms.netmgt.graph.shell.completer.NamespaceCompleter;

@Service
public class ContainerNamespaceCompleter
implements Completer {
    @Reference
    private GraphService graphService;

    public int complete(Session session, CommandLine commandLine, List<String> candidates) {
        String containerId = CommandLineUtils.extractArgument(commandLine, "--container");
        if (containerId != null) {
            GraphContainerInfo graphContainerInfo = this.graphService.getGraphContainerInfo(containerId);
            if (graphContainerInfo != null) {
                List namespaces = graphContainerInfo.getNamespaces();
                StringsCompleter delegate = new StringsCompleter();
                delegate.getStrings().addAll(namespaces);
                return delegate.complete(session, commandLine, candidates);
            }
            return -1;
        }
        return new NamespaceCompleter(this.graphService).complete(session, commandLine, candidates);
    }
}

