/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.impl;

import io.pkts.buffer.Buffer;
import io.pkts.frame.PcapGlobalHeader;
import io.pkts.frame.PcapRecordHeader;
import io.pkts.framer.EthernetFramer;
import io.pkts.framer.FramingException;
import io.pkts.framer.IPv4Framer;
import io.pkts.framer.SllFramer;
import io.pkts.packet.PCapPacket;
import io.pkts.packet.Packet;
import io.pkts.packet.PacketParseException;
import io.pkts.packet.impl.AbstractPacket;
import io.pkts.protocol.Protocol;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class PCapPacketImpl
extends AbstractPacket
implements PCapPacket {
    private final PcapRecordHeader pcapHeader;
    private static final SllFramer sllFramer = new SllFramer();
    private static final EthernetFramer ethernetFramer = new EthernetFramer();
    private static final IPv4Framer ipFramer = new IPv4Framer();
    private final PcapGlobalHeader pcapGlobalHeader;

    public PCapPacketImpl(PcapRecordHeader header, Buffer payload) {
        super(Protocol.PCAP, null, payload);
        this.pcapGlobalHeader = PcapGlobalHeader.createDefaultHeader();
        this.pcapHeader = header;
    }

    public PCapPacketImpl(PcapGlobalHeader pcapGlobalHeader, PcapRecordHeader header, Buffer payload) {
        super(Protocol.PCAP, null, payload);
        this.pcapGlobalHeader = pcapGlobalHeader;
        this.pcapHeader = header;
    }

    @Override
    public long getArrivalTime() {
        long multiplier = this.pcapGlobalHeader.timestampsInNs() ? 1000000000L : 1000000L;
        return this.pcapHeader.getTimeStampSeconds() * multiplier + this.pcapHeader.getTimeStampMicroOrNanoSeconds();
    }

    @Override
    public long getTotalLength() {
        return this.pcapHeader.getTotalLength();
    }

    @Override
    public long getCapturedLength() {
        return this.pcapHeader.getCapturedLength();
    }

    @Override
    public void verify() {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss.SSS");
        Date date = new Date(this.getArrivalTime() / 1000L);
        sb.append("Arrival Time: ").append(formatter.format(date)).append(" Epoch Time: ").append(this.pcapHeader.getTimeStampSeconds()).append(".").append(String.format("%09d", this.pcapHeader.getTimeStampMicroOrNanoSeconds())).append(" Frame Length: ").append(this.getTotalLength()).append(" Capture Length: ").append(this.getCapturedLength());
        return sb.toString();
    }

    @Override
    public void write(OutputStream out, Buffer payload) throws IOException {
        int size = payload.getReadableBytes();
        this.pcapHeader.setCapturedLength(size);
        this.pcapHeader.setTotalLength(size);
        this.pcapHeader.write(out);
        out.write(payload.getArray());
    }

    @Override
    public PCapPacket clone() {
        throw new RuntimeException("not implemented yet");
    }

    @Override
    public Packet getNextPacket() throws IOException, PacketParseException {
        Buffer payload = this.getPayload();
        if (payload == null) {
            return null;
        }
        switch (this.pcapGlobalHeader.getDataLinkType()) {
            default: {
                try {
                    return ethernetFramer.frame(this, payload);
                }
                catch (FramingException e) {
                    throw new PacketParseException(16, "Ethernet parsing failed", e);
                }
            }
            case 113: {
                return sllFramer.frame(this, payload);
            }
            case 101: 
        }
        return ipFramer.frame(this, payload);
    }
}

