/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.framer;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.framer.Framer;
import io.pkts.framer.FramingException;
import io.pkts.packet.IPv6Packet;
import io.pkts.packet.MACPacket;
import io.pkts.packet.impl.IPv6PacketImpl;
import io.pkts.protocol.Protocol;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;

public class IPv6Framer
implements Framer<MACPacket, IPv6Packet> {
    @Override
    public Protocol getProtocol() {
        return Protocol.IPv6;
    }

    @Override
    public IPv6Packet frame(MACPacket parent, Buffer payload) throws IOException {
        if (parent == null) {
            throw new IllegalArgumentException("The parent frame cannot be null");
        }
        Buffer fixedHeader = payload.readBytes(40);
        int version = (fixedHeader.getByte(0) & 0xF0) >> 4;
        if (version != 6) {
            throw new FramingException(String.format("Invalid IPv6 version: %d", version), Protocol.IPv6);
        }
        int payloadLength = fixedHeader.getUnsignedShort(4);
        int nextHeader = fixedHeader.getByte(6);
        Buffer extensionHeadersBuffer = Buffers.createBuffer((int)400);
        while (nextHeader == 0 || nextHeader == 60 || nextHeader == 43 || nextHeader == 44 || nextHeader == 51 || nextHeader == 50 || nextHeader == 135) {
            nextHeader = this.accumulateNextHeader(nextHeader, payload, extensionHeadersBuffer);
        }
        int totalLength = 40 + extensionHeadersBuffer.getWriterIndex() + payloadLength;
        Buffer data = payload.slice(Math.min(totalLength, payload.capacity()));
        return new IPv6PacketImpl(parent, Buffers.wrap((Buffer)fixedHeader, (Buffer)extensionHeadersBuffer), nextHeader, data);
    }

    private int accumulateNextHeader(int protocolNumber, Buffer payload, Buffer extensionHeadersBuffer) throws IOException, FramingException {
        int headerExtensionLen;
        AtomicInteger nextHeaderProtocol = new AtomicInteger();
        switch (protocolNumber) {
            case 0: 
            case 43: 
            case 60: {
                nextHeaderProtocol.set(payload.getByte(40));
                headerExtensionLen = 8 + payload.getByte(41) * 8;
                break;
            }
            case 44: {
                nextHeaderProtocol.set(payload.getByte(40));
                headerExtensionLen = 8;
                break;
            }
            case 51: {
                nextHeaderProtocol.set(payload.getByte(40));
                headerExtensionLen = 4 * (payload.getByte(41) + 2);
                break;
            }
            default: {
                throw new FramingException(String.format("Unsupported IPv6 extension header: %d", protocolNumber), Protocol.IPv6);
            }
        }
        Buffer tmp = payload.readBytes(headerExtensionLen);
        extensionHeadersBuffer.write(tmp.getArray());
        return nextHeaderProtocol.get();
    }

    @Override
    public boolean accept(Buffer data) {
        return false;
    }
}

