/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.impl;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.address.TelURI;
import io.pkts.packet.sip.address.impl.TelURIImpl;
import java.io.IOException;

public class TelUriParser {
    private Buffer buffer;
    private Buffer original;

    public TelUriParser(Buffer buffer, Buffer original) {
        this.buffer = buffer;
        this.original = original;
    }

    public TelURI getTelUri() throws IndexOutOfBoundsException, IOException {
        Boolean globalNumber = null;
        Buffer phone = Buffers.EMPTY_BUFFER;
        Buffer params = Buffers.EMPTY_BUFFER;
        int idxInitPhone = -1;
        int idxEndPhone = -1;
        int idxInitParams = -1;
        int idxEndParams = -1;
        while (this.buffer.hasReadableBytes()) {
            byte b = this.buffer.readByte();
            if (globalNumber == null && (globalNumber = Boolean.valueOf(b == 43)).booleanValue()) continue;
            if (idxInitPhone == -1) {
                idxInitPhone = this.buffer.getReaderIndex() - 1;
            } else if (idxEndPhone != -1 && idxInitParams == -1) {
                idxInitParams = this.buffer.getReaderIndex() - 1;
            }
            if (idxEndPhone == -1) {
                if (b == 59) {
                    idxEndPhone = this.buffer.getReaderIndex() - 1;
                } else if (TelUriParser.isCRLFSP(b)) {
                    idxEndPhone = this.buffer.getReaderIndex() - 1;
                    break;
                }
            }
            if (idxEndParams != -1 || !TelUriParser.isCRLFSP(b)) continue;
            idxEndParams = this.buffer.getReaderIndex() - 1;
            break;
        }
        int lastIndex = this.buffer.getReaderIndex();
        if (idxInitPhone == -1 || idxInitPhone == idxEndPhone) {
            throw new SipParseException(4, "No phone number in tel URI");
        }
        if (idxEndPhone == -1) {
            idxEndPhone = lastIndex;
        }
        this.buffer.setReaderIndex(idxInitPhone);
        phone = this.buffer.readBytes(idxEndPhone - idxInitPhone);
        if (idxInitParams != -1) {
            if (idxEndParams == -1) {
                idxEndParams = lastIndex;
            }
            this.buffer.setReaderIndex(idxInitParams);
            params = this.buffer.readBytes(idxEndParams - idxInitParams);
        }
        while (this.buffer.hasReadableBytes() && TelUriParser.isCRLFSP(this.buffer.peekByte())) {
            this.buffer.readByte();
        }
        return new TelURIImpl(globalNumber, phone, params, this.original);
    }

    private static boolean isCRLFSP(byte b) {
        return b == 10 || b == 13 || b == 32;
    }
}

