/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.impl;

import io.pkts.buffer.Buffer;
import io.pkts.packet.sip.SipMessage;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.header.CSeqHeader;
import io.pkts.packet.sip.header.CallIdHeader;
import io.pkts.packet.sip.header.ContactHeader;
import io.pkts.packet.sip.header.ContentLengthHeader;
import io.pkts.packet.sip.header.ContentTypeHeader;
import io.pkts.packet.sip.header.ExpiresHeader;
import io.pkts.packet.sip.header.FromHeader;
import io.pkts.packet.sip.header.MaxForwardsHeader;
import io.pkts.packet.sip.header.RecordRouteHeader;
import io.pkts.packet.sip.header.RouteHeader;
import io.pkts.packet.sip.header.SipHeader;
import io.pkts.packet.sip.header.ToHeader;
import io.pkts.packet.sip.header.ViaHeader;
import io.pkts.packet.sip.impl.PreConditions;
import io.pkts.packet.sip.impl.SipInitialLine;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public abstract class ImmutableSipMessage
implements SipMessage {
    private static final String I_AM_IMMUTABLE_NO_CAN_DO = "I am immutable, no can do";
    private final Buffer message;
    private final SipInitialLine initialLine;
    private final Map<String, List<SipHeader>> headers;
    private final Buffer body;
    private final SipHeader toHeader;
    private final SipHeader fromHeader;
    private final SipHeader cSeqHeader;
    private final SipHeader callIdHeader;
    private final SipHeader maxForwardsHeader;
    private final SipHeader viaHeader;
    private final SipHeader routeHeader;
    private final SipHeader recordRouteHeader;
    private final SipHeader contactHeader;

    protected ImmutableSipMessage(Buffer message, SipInitialLine initialLine, Map<String, List<SipHeader>> headers, SipHeader toHeader, SipHeader fromHeader, SipHeader cSeqHeader, SipHeader callIdHeader, SipHeader maxForwardsHeader, SipHeader viaHeader, SipHeader routeHeader, SipHeader recordRouteHeader, SipHeader contactHeader, Buffer body) {
        this.message = message;
        this.initialLine = initialLine;
        this.headers = headers;
        this.body = body;
        this.toHeader = toHeader;
        this.fromHeader = fromHeader;
        this.cSeqHeader = cSeqHeader;
        this.callIdHeader = callIdHeader;
        this.maxForwardsHeader = maxForwardsHeader;
        this.viaHeader = viaHeader;
        this.routeHeader = routeHeader;
        this.recordRouteHeader = recordRouteHeader;
        this.contactHeader = contactHeader;
    }

    @Override
    public SipInitialLine initialLine() {
        return this.initialLine;
    }

    public String toString() {
        return this.message.toString();
    }

    @Override
    public List<SipHeader> getAllHeaders() {
        ArrayList<SipHeader> allHeaders = new ArrayList<SipHeader>();
        for (List<SipHeader> headerValues : this.headers.values()) {
            allHeaders.addAll(headerValues);
        }
        return allHeaders;
    }

    @Override
    public Map<String, List<SipHeader>> getHeaderValues() {
        return this.headers;
    }

    @Override
    public int countNoOfHeaders() {
        return this.headers.size();
    }

    @Override
    public Buffer getInitialLine() {
        return this.initialLine.getBuffer();
    }

    protected SipInitialLine getInitialLineAsObject() {
        return this.initialLine;
    }

    @Override
    public Buffer getContent() {
        return this.body;
    }

    @Override
    public boolean hasContent() {
        return this.body != null;
    }

    @Override
    public Optional<SipHeader> getHeader(Buffer headerName) throws SipParseException {
        return this.getHeader(headerName.toString());
    }

    @Override
    public List<SipHeader> getHeaders(Buffer headerName) throws SipParseException {
        PreConditions.assertNotEmpty(headerName, "The name of the header cannot be null or the empty buffer");
        return this.getHeaders(headerName.toString());
    }

    @Override
    public List<SipHeader> getHeaders(String headerName) throws SipParseException {
        PreConditions.assertNotEmpty(headerName, "The name of the header cannot be null or the empty string");
        List<SipHeader> headerValues = this.headers.get(headerName);
        return headerValues == null || headerValues.isEmpty() ? Collections.emptyList() : new ArrayList<SipHeader>(headerValues);
    }

    @Override
    public Optional<SipHeader> getHeader(String headerName) throws SipParseException {
        return Optional.ofNullable(this.findHeader(headerName));
    }

    @Override
    public FromHeader getFromHeader() throws SipParseException {
        return this.fromHeader != null ? this.fromHeader.ensure().toFromHeader() : null;
    }

    @Override
    public ToHeader getToHeader() throws SipParseException {
        return this.toHeader != null ? this.toHeader.ensure().toToHeader() : null;
    }

    @Override
    public ViaHeader getViaHeader() throws SipParseException {
        return this.viaHeader != null ? this.viaHeader.ensure().toViaHeader() : null;
    }

    @Override
    public List<ViaHeader> getViaHeaders() throws SipParseException {
        List<SipHeader> headerValues = this.headers.get(ViaHeader.NAME.toString());
        if (headerValues == null || headerValues.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ViaHeader> vias = new ArrayList<ViaHeader>(headerValues.size());
        for (SipHeader via : headerValues) {
            vias.add(via.ensure().toViaHeader());
        }
        return vias;
    }

    @Override
    public MaxForwardsHeader getMaxForwards() throws SipParseException {
        return this.maxForwardsHeader != null ? this.maxForwardsHeader.ensure().toMaxForwardsHeader() : null;
    }

    @Override
    public RecordRouteHeader getRecordRouteHeader() throws SipParseException {
        return this.recordRouteHeader != null ? this.recordRouteHeader.ensure().toRecordRouteHeader() : null;
    }

    @Override
    public List<RecordRouteHeader> getRecordRouteHeaders() throws SipParseException {
        List<SipHeader> headerValues = this.headers.get(RecordRouteHeader.NAME.toString());
        if (headerValues == null || headerValues.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RecordRouteHeader> routes = new ArrayList<RecordRouteHeader>(headerValues.size());
        for (SipHeader route : headerValues) {
            routes.add(route.ensure().toRecordRouteHeader());
        }
        return routes;
    }

    @Override
    public RouteHeader getRouteHeader() throws SipParseException {
        return this.routeHeader != null ? this.routeHeader.ensure().toRouteHeader() : null;
    }

    @Override
    public List<RouteHeader> getRouteHeaders() throws SipParseException {
        List<SipHeader> headerValues = this.headers.get(RouteHeader.NAME.toString());
        if (headerValues == null || headerValues.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RouteHeader> routes = new ArrayList<RouteHeader>(headerValues.size());
        for (SipHeader route : headerValues) {
            routes.add(route.ensure().toRouteHeader());
        }
        return routes;
    }

    @Override
    public ExpiresHeader getExpiresHeader() throws SipParseException {
        SipHeader header = this.findHeader(ExpiresHeader.NAME.toString());
        return header != null ? header.ensure().toExpiresHeader() : null;
    }

    @Override
    public ContactHeader getContactHeader() throws SipParseException {
        return this.contactHeader != null ? this.contactHeader.ensure().toContactHeader() : null;
    }

    @Override
    public ContentTypeHeader getContentTypeHeader() throws SipParseException {
        SipHeader header = this.findHeader(ContentTypeHeader.NAME.toString());
        return header != null ? header.ensure().toContentTypeHeader() : null;
    }

    @Override
    public int getContentLength() throws SipParseException {
        SipHeader header = this.findHeader(ContentLengthHeader.NAME.toString());
        return header != null ? header.ensure().toContentLengthHeader().getContentLength() : 0;
    }

    @Override
    public CallIdHeader getCallIDHeader() throws SipParseException {
        return this.callIdHeader != null ? this.callIdHeader.ensure().toCallIdHeader() : null;
    }

    @Override
    public CSeqHeader getCSeqHeader() throws SipParseException {
        return this.cSeqHeader != null ? this.cSeqHeader.ensure().toCSeqHeader() : null;
    }

    @Override
    public boolean isInitial() throws SipParseException {
        ToHeader to = this.getToHeader();
        return to.getTag() == null;
    }

    @Override
    public void verify() {
    }

    private SipHeader findHeader(String name) {
        List<SipHeader> headerValues = this.headers.get(name);
        return headerValues != null && !headerValues.isEmpty() ? headerValues.get(0) : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SipMessage) {
            SipMessage other = (SipMessage)o;
            return this.initialLine.equals(other.initialLine());
        }
        return false;
    }

    @Override
    public Buffer toBuffer() {
        return this.message;
    }

    @Override
    public SipMessage clone() {
        return this;
    }
}

