/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.rest.impl.converter.json;

import java.util.Comparator;
import org.json.JSONArray;
import org.json.JSONObject;
import org.opennms.netmgt.graph.api.info.GraphContainerInfo;
import org.opennms.netmgt.graph.api.info.GraphInfo;
import org.opennms.netmgt.graph.rest.api.Converter;

public class GraphContainerInfoConverter
implements Converter<GraphContainerInfo, JSONObject> {
    public boolean canConvert(Class<GraphContainerInfo> type) {
        return GraphContainerInfo.class.isAssignableFrom(type);
    }

    public JSONObject convert(GraphContainerInfo input) {
        JSONObject jsonGraphContainerInfoObject = new JSONObject();
        jsonGraphContainerInfoObject.put("id", (Object)input.getId());
        jsonGraphContainerInfoObject.put("label", (Object)input.getLabel());
        jsonGraphContainerInfoObject.put("description", (Object)input.getDescription());
        JSONArray graphInfoArray = new JSONArray();
        input.getGraphInfos().stream().sorted(Comparator.comparing(GraphInfo::getNamespace)).forEach(graphInfo -> {
            JSONObject jsonGraphInfoObject = new JSONObject();
            jsonGraphInfoObject.put("namespace", (Object)graphInfo.getNamespace());
            jsonGraphInfoObject.put("label", (Object)graphInfo.getLabel());
            jsonGraphInfoObject.put("description", (Object)graphInfo.getDescription());
            graphInfoArray.put((Object)jsonGraphInfoObject);
        });
        jsonGraphContainerInfoObject.put("graphs", (Object)graphInfoArray);
        return jsonGraphContainerInfoObject;
    }
}

