/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.rest.impl;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.opennms.netmgt.graph.api.search.GraphSearchService;
import org.opennms.netmgt.graph.api.search.SearchCriteria;
import org.opennms.netmgt.graph.rest.api.GraphSearchRestService;

public class GraphSearchRestServiceImpl
implements GraphSearchRestService {
    private GraphSearchService graphSearchService;

    public GraphSearchRestServiceImpl(GraphSearchService graphSearchService) {
        this.graphSearchService = Objects.requireNonNull(graphSearchService);
    }

    public Response getSuggestions(String namespace, String input) {
        List result = this.graphSearchService.getSuggestions(namespace, input);
        if (result.size() < 1) {
            return Response.noContent().build();
        }
        return Response.ok((Object)result).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    public Response search(String namespace, String providerId, String criteria) {
        SearchCriteria searchCriteria = new SearchCriteria(providerId, namespace, criteria);
        List result = this.graphSearchService.search(searchCriteria);
        if (result.size() < 1) {
            return Response.noContent().build();
        }
        List vertexRefs = result.stream().map(v -> v.getVertexRef()).collect(Collectors.toList());
        return Response.ok(vertexRefs).type(MediaType.APPLICATION_JSON_TYPE).build();
    }
}

