/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.amqp.eventreceiver.internal;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEventProcessor
implements Processor {
    public static final Logger LOG = LoggerFactory.getLogger(DefaultEventProcessor.class);
    public static final String EVENT_HEADER_SYSTEMID = "systemId";
    public static final String EVENT_HEADER_FOREIGNSOURCE = "foreignSource";
    public static final String EVENT_HEADER_FOREIGNID = "foreignId";
    private NodeDao nodeDao;

    public void process(Exchange exchange) throws Exception {
        String eventXml = (String)exchange.getIn().getBody(String.class);
        Event event = (Event)JaxbUtils.unmarshal(Event.class, (String)eventXml);
        String systemId = (String)exchange.getIn().getHeader(EVENT_HEADER_SYSTEMID, String.class);
        if (event.getNodeid() > 0L) {
            String foreignId;
            String foreignSource = (String)exchange.getIn().getHeader(EVENT_HEADER_FOREIGNSOURCE, String.class);
            OnmsNode node = this.nodeDao.findByForeignId(foreignSource, foreignId = (String)exchange.getIn().getHeader(EVENT_HEADER_FOREIGNID, String.class));
            if (node != null && node.getId() != null) {
                event.setNodeid(Long.valueOf(node.getId().longValue()));
                event.setDistPoller(systemId);
                event.setSource("Endpoint=" + systemId + ":" + event.getSource());
            } else {
                LOG.warn("Could not find node {}/{} in the database, cannot update node ID to local value; discarding event", (Object)foreignSource, (Object)foreignId);
                exchange.setProperty("CamelRouteStop", (Object)Boolean.TRUE);
            }
        }
        exchange.getIn().setBody((Object)event, Event.class);
    }

    public NodeDao getNodeDao() {
        return this.nodeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.nodeDao = nodeDao;
    }
}

