/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.slp.internal.sa;

import java.io.IOException;
import org.sblim.slp.ServiceLocationException;
import org.sblim.slp.internal.TRC;
import org.sblim.slp.internal.sa.ServiceAgent;

public abstract class RecieverThread
implements Runnable {
    private Thread iThread;
    private volatile boolean iStop;
    private boolean iInited;
    private Object iInitLock = new Object();
    protected ServiceAgent iSrvAgent;

    public RecieverThread(String pName, ServiceAgent pSrvAgent) {
        this.iThread = new Thread((Runnable)this, pName);
        this.iSrvAgent = pSrvAgent;
    }

    public void start() {
        this.iThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wait4init() {
        Object object = this.iInitLock;
        synchronized (object) {
            try {
                if (this.iInited) {
                    return;
                }
                this.iInitLock.wait();
                return;
            }
            catch (InterruptedException e) {
                TRC.error(e);
            }
        }
    }

    public void stop() {
        this.stop(true);
    }

    public void stop(boolean pWait) {
        this.iStop = true;
        if (pWait) {
            this.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object = this.iInitLock;
        synchronized (object) {
            TRC.debug("initing");
            this.initialize();
            this.iInited = true;
            TRC.debug("inited");
            try {
                this.iInitLock.notifyAll();
            }
            catch (IllegalMonitorStateException e) {
                TRC.error(e);
            }
        }
        while (!this.iStop) {
            try {
                this.mainLoop();
            }
            catch (Exception e) {
                TRC.error(e);
                RecieverThread.sleep(100);
                this.initialize();
            }
        }
        this.close();
        this.iStop = false;
        TRC.debug("STOPPED");
    }

    protected abstract void init() throws ServiceLocationException, IOException;

    protected abstract void mainLoop() throws IOException;

    protected abstract void close();

    private void join() {
        try {
            this.iThread.join();
        }
        catch (InterruptedException e) {
            TRC.error(e);
        }
    }

    private void initialize() {
        try {
            this.init();
        }
        catch (ServiceLocationException e) {
            TRC.error(e);
        }
        catch (IOException e) {
            TRC.error(e);
        }
    }

    private static void sleep(int pMillis) {
        try {
            Thread.sleep(pMillis);
        }
        catch (InterruptedException e) {
            TRC.error(e);
        }
    }
}

