/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.slp.internal.msg;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.sblim.slp.ServiceLocationException;
import org.sblim.slp.internal.TRC;
import org.sblim.slp.internal.msg.MsgHeader;
import org.sblim.slp.internal.msg.ReplyMessage;
import org.sblim.slp.internal.msg.SLPInputStream;
import org.sblim.slp.internal.msg.SLPMessage;
import org.sblim.slp.internal.msg.SLPOutputStream;
import org.sblim.slp.internal.msg.SerializeOption;

public class AttributeReply
extends ReplyMessage {
    private List iAttrList;

    public static SLPMessage parse(MsgHeader pHdr, SLPInputStream pInStr) throws ServiceLocationException, IOException {
        AttributeReply reply = new AttributeReply(pHdr, pInStr.read16(), pInStr.readAttributeList());
        if (pInStr.readAuthBlockList() != null) {
            TRC.warning("Non empty auth block!");
        }
        return reply;
    }

    public AttributeReply(int pErrorCode, List pAttrList) {
        super(7, pErrorCode);
        this.iAttrList = pAttrList;
    }

    public AttributeReply(String pLangTag, int pErrorCode, List pAttrList) {
        super(7, pLangTag, pErrorCode);
        this.iAttrList = pAttrList;
    }

    public AttributeReply(MsgHeader pHeader, int pErrorCode, List pAttrList) {
        super(pHeader, pErrorCode);
        this.iAttrList = pAttrList;
    }

    public Iterator getResultIterator() {
        return this.iAttrList == null ? null : this.iAttrList.iterator();
    }

    protected boolean serializeBody(SLPOutputStream pOutStr, SerializeOption pOption) {
        return pOutStr.write16(this.getErrorCode()) && pOutStr.writeAttributeList(this.iAttrList) && pOutStr.writeAuthBlockList(null);
    }

    public Iterator getExceptionIterator() {
        return null;
    }
}

