/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.slp.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.sblim.slp.internal.SLPDefaults;

public final class SLPConfig {
    private static InetAddress cBroadcastAddress;
    private static SLPConfig cInstance;
    private static InetAddress cLocalHostAddress;
    private static InetAddress cLoopBackV4;
    private static InetAddress cLoopBackV6;
    private static InetAddress cMulticastAddress;
    private static InetAddress cSRVLOC_MulticastAddress;
    private static InetAddress cSRVLOC_DA_MulticastAddress;
    private static Logger cLogger;
    private static FileHandler cFileHandler;
    private static ConsoleHandler cConsoleHandler;
    private static final String DEFAULT_LOGGER_NAMESPACE = "org.sblim.slp";

    private static InetAddress getByName(String pName) {
        try {
            return InetAddress.getByName(pName);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static InetAddress getBroadcastAddress() {
        return cBroadcastAddress;
    }

    public static synchronized SLPConfig getGlobalCfg() {
        if (cInstance == null) {
            cInstance = new SLPConfig();
        }
        return cInstance;
    }

    public static InetAddress getLoopbackV4() {
        return cLoopBackV4;
    }

    public static InetAddress getLoopbackV6() {
        return cLoopBackV6;
    }

    public static InetAddress getMulticastAddress() {
        return cMulticastAddress;
    }

    public static InetAddress getSRVLOC_MulticastAddress() {
        return cSRVLOC_MulticastAddress;
    }

    public static InetAddress getSRVLOC_DA_MulticastAddress() {
        return cSRVLOC_DA_MulticastAddress;
    }

    private static int getIntProperty(String pName, int pDefaultValue, int pMinValue, int pMaxValue) {
        int value = Integer.getInteger(pName, pDefaultValue);
        return Math.min(pMaxValue, Math.max(pMinValue, value));
    }

    private SLPConfig() {
        try {
            Class.forName("org.sblim.cimclient.internal.util.WBEMConfiguration");
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        Properties slpProperties = new Properties(new Properties());
        try {
            InputStream inputstream = this.getConfigURLStream();
            if (inputstream != null) {
                slpProperties.load(inputstream);
            }
            Iterator<Map.Entry<Object, Object>> iterator = slpProperties.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Object, Object> entry = iterator.next();
                System.setProperty(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
            }
        }
        catch (IOException e) {
            System.out.println("Error while parsing property file");
            e.printStackTrace();
        }
        cLogger = Logger.getLogger(DEFAULT_LOGGER_NAMESPACE);
        this.setUpLoggingFramework();
    }

    public int getActiveDiscoveryGranularity() {
        return SLPConfig.getIntProperty("net.slp.DAActiveDiscoveryGranularity", 900, 0, 800);
    }

    public int getActiveDiscoveryInterval() {
        int interval = SLPConfig.getIntProperty("net.slp.DAActiveDiscoveryInterval", 900, 0, 10800);
        if (interval > 0 && interval < 300) {
            return 300;
        }
        return interval;
    }

    public int[] getDADiscoveryTimeouts() {
        return this.parseTimeouts("net.slp.DADiscoveryTimeouts", SLPDefaults.DA_DISCOVERY_TIMEOUTS);
    }

    public int[] getDatagramTimeouts() {
        return this.parseTimeouts("net.slp.datagramTimeouts", SLPDefaults.DATAGRAM_TIMEOUTS);
    }

    public List getInterfaces() {
        String property = System.getProperty("net.slp.interfaces");
        List addresses = SLPConfig.parseList(property);
        int count = addresses == null ? 0 : addresses.size();
        ArrayList<InetAddress> interfaces = new ArrayList<InetAddress>(count);
        if (count == 0) {
            interfaces.add(cLocalHostAddress);
            interfaces.add(cLoopBackV4);
            interfaces.add(cLoopBackV6);
        } else {
            for (int i = 0; i < count; ++i) {
                String address = (String)addresses.get(i);
                try {
                    InetAddress inetAddress = InetAddress.getByName(address);
                    if (interfaces.contains(inetAddress)) continue;
                    if (inetAddress.equals(cLocalHostAddress)) {
                        interfaces.add(0, inetAddress);
                        continue;
                    }
                    interfaces.add(inetAddress);
                    continue;
                }
                catch (UnknownHostException e) {
                    // empty catch block
                }
            }
        }
        return interfaces;
    }

    public int getPort() {
        return Integer.getInteger("net.slp.port", 427);
    }

    public void setPort(int pPort) {
        System.setProperty("net.slp.port", Integer.toString(pPort));
    }

    public Level getTraceLevel() {
        String str = System.getProperty("net.slp.trc.level");
        if ("OFF".equalsIgnoreCase(str)) {
            return Level.OFF;
        }
        if ("ERROR".equalsIgnoreCase(str)) {
            return Level.SEVERE;
        }
        if ("WARNING".equalsIgnoreCase(str)) {
            return Level.WARNING;
        }
        if ("INFO".equalsIgnoreCase(str)) {
            return Level.INFO;
        }
        if ("ALL".equalsIgnoreCase(str)) {
            return Level.FINEST;
        }
        return Level.SEVERE;
    }

    public void setTraceLevel(String pLevel) {
        System.setProperty("net.slp.trc.level", pLevel);
    }

    public void setUseIPv6(boolean pValue) {
        System.setProperty("net.slp.useipv6", Boolean.toString(pValue));
    }

    public boolean useIPv6() {
        return SLPConfig.getBoolean("net.slp.useipv6", true);
    }

    public void setUseIPv4(boolean pValue) {
        System.setProperty("net.slp.useipv4", new Boolean(pValue).toString());
    }

    public boolean useIPv4() {
        return SLPConfig.getBoolean("net.slp.useipv4", true);
    }

    public InetAddress getLocalHost() {
        List interfaces = this.getInterfaces();
        return (InetAddress)interfaces.get(0);
    }

    public int getMaximumResults() {
        int value = Integer.getInteger("net.slp.maxResults", Integer.MAX_VALUE);
        return value >= 1 && value <= Integer.MAX_VALUE ? value : Integer.MAX_VALUE;
    }

    public int getMTU() {
        return SLPConfig.getIntProperty("net.slp.MTU", 1400, 128, 8192);
    }

    public int getMulticastMaximumWait() {
        return SLPConfig.getIntProperty("net.slp.multicastMaximumWait", 2000, 1000, 60000);
    }

    public int getMulticastRadius() {
        return SLPConfig.getIntProperty("net.slp.multicastTTL", 255, 1, 255);
    }

    public int[] getMulticastTimeouts() {
        return this.parseTimeouts("net.slp.multicastTimeouts", SLPDefaults.MULTICAST_TIMEOUTS);
    }

    public List getPreconfiguredDAs() {
        String addressString = System.getProperty("net.slp.DAAddresses", "");
        List addresses = SLPConfig.parseList(addressString);
        if (addresses == null) {
            return null;
        }
        ArrayList<InetAddress> result = new ArrayList<InetAddress>();
        Iterator iter = addresses.iterator();
        while (iter.hasNext()) {
            try {
                result.add(InetAddress.getByName((String)iter.next()));
            }
            catch (UnknownHostException e) {}
        }
        return result;
    }

    public List getConfiguredScopes() {
        ArrayList<String> scopes = SLPConfig.parseList("net.slp.useScopes");
        if (scopes == null) {
            scopes = new ArrayList<String>();
        }
        if (scopes.size() == 0) {
            scopes.add("default");
        }
        return scopes;
    }

    public List getSAOnlyScopes() {
        return SLPConfig.parseList("net.slp.SAOnlyScopes");
    }

    public int getServerSocketQueueLength() {
        return SLPConfig.getIntProperty("net.slp.serverSocketQueueLength", 10, 0, Integer.MAX_VALUE);
    }

    public int getTCPTimeout() {
        return SLPConfig.getIntProperty("net.slp.TCPTimeout", 20000, 100, 360000);
    }

    public boolean getTraceMsg() {
        return Boolean.getBoolean("net.slp.traceMsg");
    }

    public boolean isBroadcastOnly() {
        return Boolean.getBoolean("net.slp.isBroadcastOnly");
    }

    public boolean isDA() {
        return Boolean.getBoolean("net.slp.isDA");
    }

    public boolean isSA() {
        return !this.isDA();
    }

    private static boolean getBoolean(String pPropName, boolean pDefaultValue) {
        if (System.getProperty(pPropName) == null) {
            return pDefaultValue;
        }
        return Boolean.getBoolean(pPropName);
    }

    private InputStream getConfigURLStream() {
        String configURL = System.getProperty("net.slp.configURL");
        if (configURL != null) {
            if (configURL.trim().length() > 0) {
                try {
                    URL url = new URL(configURL);
                    InputStream inputstream = url.openStream();
                    return inputstream;
                }
                catch (MalformedURLException e) {
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            return null;
        }
        for (int i = 0; i < SLPDefaults.CONF_URLS.length; ++i) {
            configURL = SLPDefaults.CONF_URLS[i];
            try {
                URL url = new URL(configURL);
                InputStream inputstream = url.openStream();
                return inputstream;
            }
            catch (Exception exception) {
                continue;
            }
        }
        return null;
    }

    private static List parseList(String pListStr) {
        if (pListStr == null || pListStr.length() == 0) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(pListStr, ",");
        if (tokenizer.countTokens() == 0) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>(tokenizer.countTokens());
        while (tokenizer.hasMoreTokens()) {
            String str = tokenizer.nextToken().trim();
            if (str.length() == 0) continue;
            list.add(str);
        }
        return list.size() == 0 ? null : list;
    }

    private int[] parseTimeouts(String pPropertyName, int[] pDefaultTimeouts) {
        String value = System.getProperty(pPropertyName);
        List list = SLPConfig.parseList(value);
        if (list == null) {
            return pDefaultTimeouts;
        }
        int[] timeouts = new int[list.size()];
        for (int pos = 0; pos < list.size(); ++pos) {
            String timeoutElem = (String)list.get(pos);
            try {
                timeouts[pos] = Integer.parseInt(timeoutElem);
                continue;
            }
            catch (NumberFormatException e) {
                return pDefaultTimeouts;
            }
        }
        return timeouts;
    }

    public Logger getLogger() {
        return cLogger;
    }

    private void setUpLoggingFramework() {
        cLogger.setUseParentHandlers(false);
        if (!this.getTraceLevel().equals(Level.OFF)) {
            if (cConsoleHandler == null) {
                cConsoleHandler = new ConsoleHandler();
                cLogger.addHandler(cConsoleHandler);
            }
            cConsoleHandler.setLevel(this.getTraceLevel());
            cLogger.setLevel(Level.ALL);
            try {
                if (cFileHandler == null) {
                    cFileHandler = new FileHandler("slp.log");
                    cLogger.addHandler(cFileHandler);
                }
                cFileHandler.setLevel(this.getTraceLevel());
            }
            catch (Exception e) {
                cLogger.log(Level.INFO, "Logging into file slp.log could not be exhausted.");
            }
        } else {
            Handler[] handlers = cLogger.getHandlers();
            for (int i = 0; i < handlers.length; ++i) {
                handlers[i].setLevel(Level.OFF);
            }
            cLogger.setLevel(Level.OFF);
        }
    }

    static {
        cInstance = null;
        cLoopBackV4 = SLPConfig.getByName("127.0.0.1");
        cLoopBackV6 = SLPConfig.getByName("::1");
        cMulticastAddress = SLPConfig.getByName("239.255.255.253");
        cBroadcastAddress = SLPConfig.getByName("255.255.255.255");
        try {
            cLocalHostAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }
}

