/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.slp;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class ServiceType
implements Serializable {
    private static final long serialVersionUID = -4850546870881037017L;
    private boolean iIsServiceURL = true;
    private String iPrincipleType = "";
    private String iAbstractType = "";
    private String iNamingAuthority = "";
    private int iHashCode = 0;

    public ServiceType(String pType) {
        this.parse(pType);
    }

    public boolean isServiceURL() {
        return this.iIsServiceURL;
    }

    public boolean isAbstractType() {
        return this.iAbstractType.length() > 0;
    }

    public boolean isNADefault() {
        return this.iNamingAuthority.length() <= 0;
    }

    public String getConcreteTypeName() {
        return this.iAbstractType;
    }

    public String getPrincipleTypeName() {
        return this.iPrincipleType;
    }

    public String getAbstractTypeName() {
        if (this.isAbstractType()) {
            return "service:" + this.iPrincipleType + (this.iNamingAuthority.length() <= 0 ? "" : "." + this.iNamingAuthority);
        }
        return "";
    }

    public String getNamingAuthority() {
        return this.iNamingAuthority;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ServiceType)) {
            return false;
        }
        ServiceType servicetype = (ServiceType)obj;
        return this.iIsServiceURL == servicetype.iIsServiceURL && this.iPrincipleType.equals(servicetype.iPrincipleType) && this.iAbstractType.equals(servicetype.iAbstractType) && this.iNamingAuthority.equals(servicetype.iNamingAuthority);
    }

    public String toString() {
        return (this.iIsServiceURL ? "service:" : "") + this.iPrincipleType + (this.iNamingAuthority.length() <= 0 ? "" : "." + this.iNamingAuthority) + (this.iAbstractType.length() <= 0 ? "" : ":" + this.iAbstractType);
    }

    public int hashCode() {
        if (this.iHashCode == 0) {
            this.iHashCode = this.toString().hashCode();
        }
        return this.iHashCode;
    }

    private void parse(String pString) {
        StringTokenizer st = new StringTokenizer(pString, ":.", true);
        try {
            while (true) {
                String token;
                if ((token = st.nextToken()).equals(":") || token.equals(".")) {
                    continue;
                }
                if (!token.equalsIgnoreCase("service")) {
                    this.iIsServiceURL = false;
                    while (true) {
                        this.iPrincipleType = this.iPrincipleType + token.toLowerCase();
                        if (!st.hasMoreTokens()) break;
                        token = st.nextToken();
                    }
                    ServiceType.validateTypeComponent(this.iPrincipleType);
                    if (st.hasMoreTokens()) continue;
                    return;
                }
                token = st.nextToken();
                if (!token.equals(":")) continue;
                this.iPrincipleType = st.nextToken().toLowerCase();
                ServiceType.validateTypeComponent(this.iPrincipleType);
                if (!st.hasMoreTokens()) {
                    return;
                }
                token = st.nextToken();
                if (token.equals(".")) {
                    token = st.nextToken();
                    ServiceType.validateTypeComponent(token);
                    if (token.equalsIgnoreCase("iana")) continue;
                    this.iNamingAuthority = token.toLowerCase();
                    if (!st.hasMoreTokens()) {
                        return;
                    }
                    token = st.nextToken();
                }
                if (!token.equals(":")) continue;
                String abstractTypeToken = st.nextToken();
                ServiceType.validateTypeComponent(abstractTypeToken);
                this.iAbstractType = abstractTypeToken.toLowerCase();
                if (!st.hasMoreTokens()) break;
            }
            return;
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    private static void validateTypeComponent(String str) {
        int length = str.length();
        for (int pos = 0; pos < length; ++pos) {
            char ch = str.charAt(pos);
            if (Character.isLetterOrDigit(ch) || ch == '+' || ch == '-') continue;
            throw new IllegalArgumentException();
        }
    }
}

