/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rrd.rrdtool;

import java.io.File;
import java.util.LinkedHashSet;

public final class Interface {
    private static final String LIBRARY_NAME = "jrrd";
    private static final String PROPERTY_NAME = "opennms.library.jrrd";
    private static Interface s_singleton = null;

    public static synchronized native String[] launch(String var0);

    public static synchronized void init() throws SecurityException, UnsatisfiedLinkError {
        if (Interface.isLoaded()) {
            return;
        }
        Interface.setInstance(new Interface());
    }

    private static boolean isLoaded() {
        return s_singleton != null;
    }

    public static synchronized void reload() throws SecurityException, UnsatisfiedLinkError {
        Interface.setInstance(null);
        Interface.init();
    }

    private Interface() throws SecurityException, UnsatisfiedLinkError {
        String string = System.getProperty(PROPERTY_NAME);
        try {
            Interface.debug("System property 'opennms.library.jrrd' set to '" + System.getProperty(PROPERTY_NAME) + ".  Attempting to load " + LIBRARY_NAME + " library from this location.");
            System.load(string);
        }
        catch (Throwable throwable) {
            Interface.debug("System property 'opennms.library.jrrd' not set.  Attempting to find library.");
            System.loadLibrary(LIBRARY_NAME);
        }
        Interface.info("Successfully loaded jrrd library.");
    }

    private static void loadLibrary() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        if (System.getProperty("java.library.path") != null) {
            for (String string : System.getProperty("java.library.path").split(File.pathSeparator)) {
                linkedHashSet.add(string);
            }
        }
        for (String string : new String[]{"/usr/lib64/jni", "/usr/lib64", "/usr/local/lib64", "/usr/lib/jni", "/usr/lib", "/usr/local/lib"}) {
            linkedHashSet.add(string);
        }
        for (String string : linkedHashSet) {
            for (String string2 : new String[]{"", "lib"}) {
                for (String string3 : new String[]{".jnilib", ".dylib", ".so"}) {
                    File file = new File(string + File.separator + string2 + LIBRARY_NAME + string3);
                    if (!file.exists()) continue;
                    try {
                        System.load(file.getCanonicalPath());
                        return;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
        Interface.debug("Unable to locate 'jrrd' in common paths.  Attempting System.loadLibrary() as a last resort.");
        System.loadLibrary(LIBRARY_NAME);
    }

    public static synchronized Interface getInstance() {
        Interface.assertState(Interface.isLoaded(), "The RRD JNI interface has not been initialized");
        return s_singleton;
    }

    public static synchronized void setInstance(Interface interface_) {
        s_singleton = interface_;
    }

    public static void debug(String string) {
        System.err.println("[DEBUG] " + string);
    }

    public static void info(String string) {
        System.err.println("[INFO] " + string);
    }

    public static void assertState(boolean bl, String string) {
        if (!bl) {
            throw new IllegalStateException(string);
        }
    }

    public static void main(String[] stringArray) {
        try {
            Interface.reload();
            String string = stringArray[0];
            System.out.println("filename=" + string);
            String string2 = "create \"" + string + "\" --start N" + " --step 900 DS:test:COUNTER:900:0:100 RRA:MIN:0.5:1:1000";
            System.out.println("issuing RRD cmd: " + string2);
            Interface.launch(string2);
            System.out.println("command completed.");
        }
        catch (Throwable throwable) {
            System.err.println("unexpected error, reason: " + throwable);
            throwable.printStackTrace();
        }
    }
}

