/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.mock;

import com.google.common.collect.Maps;
import java.net.InetAddress;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.opennms.netmgt.dao.api.AbstractInterfaceToNodeCache;
import org.opennms.netmgt.dao.api.InterfaceToNodeCache;

public class MockInterfaceToNodeCache
extends AbstractInterfaceToNodeCache {
    private Map<Key, InterfaceToNodeCache.Entry> keyToEntry = Maps.newHashMap();

    public boolean setNodeId(String location, InetAddress ipAddr, int nodeId) {
        return this.keyToEntry.put(new Key(location, ipAddr), new InterfaceToNodeCache.Entry(nodeId, 0)) != null;
    }

    public boolean removeNodeId(String location, InetAddress ipAddr, int nodeId) {
        return this.keyToEntry.remove(new Key(location, ipAddr)) != null;
    }

    public Optional<InterfaceToNodeCache.Entry> getFirst(String location, InetAddress ipAddr) {
        return Optional.ofNullable(this.keyToEntry.get(new Key(location, ipAddr)));
    }

    public void dataSourceSync() {
    }

    public int size() {
        return this.keyToEntry.size();
    }

    public void clear() {
        this.keyToEntry.clear();
    }

    public void removeInterfacesForNode(int nodeId) {
    }

    private static class Key {
        private String location;
        private InetAddress ipAddr;

        public Key(String location, InetAddress ipAddr) {
            this.location = location;
            this.ipAddr = ipAddr;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return Objects.equals(this.location, key.location) && Objects.equals(this.ipAddr, key.ipAddr);
        }

        public int hashCode() {
            return Objects.hash(this.location, this.ipAddr);
        }
    }
}

