/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.mock;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.opennms.netmgt.dao.api.AssetRecordDao;
import org.opennms.netmgt.dao.mock.AbstractMockDao;
import org.opennms.netmgt.model.OnmsAssetRecord;

public class MockAssetRecordDao
extends AbstractMockDao<OnmsAssetRecord, Integer>
implements AssetRecordDao {
    private AtomicInteger m_id = new AtomicInteger(0);

    @Override
    protected void generateId(OnmsAssetRecord asset) {
        asset.setId(Integer.valueOf(this.m_id.incrementAndGet()));
    }

    @Override
    protected Integer getId(OnmsAssetRecord asset) {
        return asset.getId();
    }

    public OnmsAssetRecord findByNodeId(Integer id) {
        for (OnmsAssetRecord asset : this.findAll()) {
            if (asset.getNode().getId() != id) continue;
            return asset;
        }
        return null;
    }

    public Map<String, Integer> findImportedAssetNumbersToNodeIds(String foreignSource) {
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        for (OnmsAssetRecord asset : this.findAll()) {
            ret.put(asset.getAssetNumber(), asset.getNode().getId());
        }
        return ret;
    }

    public List<OnmsAssetRecord> getDistinctProperties() {
        return this.findAll();
    }
}

