/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.mock;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.opennms.netmgt.dao.mock.EventWrapper;
import org.opennms.netmgt.events.api.EventListener;
import org.opennms.netmgt.events.api.model.IEvent;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventAnticipator
implements EventListener {
    private static final Logger LOG = LoggerFactory.getLogger(EventAnticipator.class);
    boolean m_discardUnanticipated = false;
    final List<EventWrapper> m_anticipatedEvents = new ArrayList<EventWrapper>();
    final List<Event> m_anticipatedEventsReceived = new ArrayList<Event>();
    final List<Event> m_unanticipatedEvents = new ArrayList<Event>();

    public boolean isDiscardUnanticipated() {
        return this.m_discardUnanticipated;
    }

    public void setDiscardUnanticipated(boolean discardUnanticipated) {
        this.m_discardUnanticipated = discardUnanticipated;
    }

    public void anticipateEvent(Event event) {
        this.anticipateEvent(event, false);
    }

    public synchronized void anticipateEvent(Event event, boolean checkUnanticipatedList) {
        EventWrapper w = new EventWrapper(event);
        if (checkUnanticipatedList) {
            Iterator<Event> it = this.m_unanticipatedEvents.iterator();
            while (it.hasNext()) {
                Event unE = it.next();
                EventWrapper unW = new EventWrapper(unE);
                if (!unW.equals(w)) continue;
                it.remove();
                this.notifyAll();
                return;
            }
        }
        this.m_anticipatedEvents.add(w);
        this.notifyAll();
    }

    public synchronized void eventReceived(Event event) {
        EventWrapper w = new EventWrapper(event);
        if (this.m_anticipatedEvents.contains(w)) {
            this.m_anticipatedEvents.remove(w);
            this.m_anticipatedEventsReceived.add(event);
            this.notifyAll();
        } else {
            this.saveUnanticipatedEvent(event);
        }
    }

    private synchronized void saveUnanticipatedEvent(Event event) {
        if (!this.m_discardUnanticipated) {
            this.m_unanticipatedEvents.add(event);
        }
    }

    public synchronized List<Event> getAnticipatedEvents() {
        return Collections.unmodifiableList(this.m_anticipatedEvents.stream().map(EventWrapper::getEvent).collect(Collectors.toList()));
    }

    public synchronized List<Event> getAnticipatedEventsReceived() {
        return Collections.unmodifiableList(this.m_anticipatedEventsReceived);
    }

    public synchronized List<Event> getUnanticipatedEvents() {
        return Collections.unmodifiableList(this.m_unanticipatedEvents);
    }

    public synchronized void reset() {
        this.resetAnticipated();
        this.resetUnanticipated();
    }

    public synchronized void resetUnanticipated() {
        this.m_unanticipatedEvents.clear();
    }

    public synchronized void resetAnticipated() {
        this.m_anticipatedEvents.clear();
        this.m_anticipatedEventsReceived.clear();
    }

    public synchronized Collection<Event> waitForAnticipated(long millis) {
        long last;
        long now = last = System.currentTimeMillis();
        for (long waitTime = millis; waitTime > 0L; waitTime -= now - last) {
            if (this.m_anticipatedEvents.isEmpty()) {
                return new ArrayList<Event>(0);
            }
            try {
                this.wait(waitTime);
            }
            catch (InterruptedException e) {
                LOG.error("interrupted while waiting for anticipated events", (Throwable)e);
            }
            now = System.currentTimeMillis();
            last = now;
        }
        return this.getAnticipatedEvents();
    }

    public void eventProcessed(Event event) {
    }

    public synchronized void verifyAnticipated(long wait, long sleepMiddle, long sleepAfter, int anticipatedSize, int unanticipatedSize) {
        StringBuilder problems = new StringBuilder();
        Collection<Event> missingEvents = this.waitForAnticipated(wait);
        if (sleepMiddle > 0L) {
            try {
                Thread.sleep(sleepMiddle);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (anticipatedSize >= 0 && missingEvents.size() != anticipatedSize) {
            problems.append(missingEvents.size() + " expected events still outstanding (expected " + anticipatedSize + "):\n");
            problems.append(EventAnticipator.listEvents("\t", missingEvents));
        }
        if (sleepAfter > 0L) {
            try {
                Thread.sleep(sleepAfter);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (unanticipatedSize >= 0 && this.getUnanticipatedEvents().size() != unanticipatedSize) {
            problems.append(this.getUnanticipatedEvents().size() + " unanticipated events received (expected " + unanticipatedSize + "):\n");
            problems.append(EventAnticipator.listEvents("\t", this.getUnanticipatedEvents()));
        }
        if (problems.length() > 0) {
            problems.deleteCharAt(problems.length() - 1);
            Assert.fail((String)problems.toString());
        }
    }

    public void verifyAnticipated() {
        this.verifyAnticipated(0L, 0L, 0L, 0, 0);
    }

    private static String listEvents(String prefix, Collection<Event> events) {
        StringBuilder b = new StringBuilder();
        for (Event event : events) {
            b.append(prefix);
            b.append(event.getUei() + " / " + event.getNodeid() + " / " + event.getInterface() + " / " + event.getService());
            b.append("\n");
        }
        return b.toString();
    }

    public String getName() {
        return "eventAnticipator";
    }

    public void onEvent(IEvent e) {
        this.eventReceived(Event.copyFrom((IEvent)e));
    }
}

