/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.web;

import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.aries.blueprint.services.BlueprintExtenderService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.blueprint.container.BlueprintContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlueprintContextListener
implements ServletContextListener {
    public static final String CONTAINER_ATTRIBUTE = "org.apache.aries.blueprint.container";
    public static final String LOCATION_PARAM = "blueprintLocation";
    public static final String DEFAULT_LOCATION = "OSGI-INF/blueprint.xml";
    public static final String BUNDLE_CONTEXT_PARAM = "blueprintContext";
    public static final String DEFAULT_BUNDLE_CONTEXT_ATTRIBUTE = "osgi-bundlecontext";

    public void contextInitialized(ServletContextEvent event) {
        ServletContext sc = event.getServletContext();
        BundleContext bc = this.getBundleContext(sc);
        if (bc == null) {
            return;
        }
        BlueprintExtenderService blueprintExtender = this.getBlueprintExtenderService(bc);
        if (blueprintExtender == null) {
            return;
        }
        try {
            BlueprintContainer container = blueprintExtender.getContainer(bc.getBundle());
            if (container == null) {
                List<Object> blueprintResources = this.getBlueprintAppList(sc, bc.getBundle());
                container = blueprintResources.isEmpty() ? blueprintExtender.createContainer(bc.getBundle()) : blueprintExtender.createContainer(bc.getBundle(), blueprintResources);
            }
            if (container == null) {
                sc.log("Failed to startup blueprint container.");
            } else {
                sc.setAttribute(CONTAINER_ATTRIBUTE, (Object)container);
            }
        }
        catch (Exception e) {
            sc.log("Failed to startup blueprint container. " + e, (Throwable)e);
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        ServletContext sc = event.getServletContext();
        BlueprintContainer container = (BlueprintContainer)sc.getAttribute(CONTAINER_ATTRIBUTE);
        if (container == null) {
            return;
        }
        BundleContext bc = this.getBundleContext(sc);
        if (bc == null) {
            return;
        }
        BlueprintExtenderService blueprintExtender = this.getBlueprintExtenderService(bc);
        if (blueprintExtender == null) {
            return;
        }
        blueprintExtender.destroyContainer(bc.getBundle(), container);
    }

    private List<Object> getBlueprintAppList(ServletContext sc, Bundle applicationBundle) {
        String location = sc.getInitParameter(LOCATION_PARAM);
        if (location == null) {
            location = DEFAULT_LOCATION;
        }
        LinkedList<Object> blueprintResources = new LinkedList<Object>();
        URL entry = applicationBundle.getEntry(location);
        if (entry != null) {
            blueprintResources.add(entry);
        }
        return blueprintResources;
    }

    private BundleContext getBundleContext(ServletContext sc) {
        BundleContext bc;
        String bundleContextAttributeName = sc.getInitParameter(BUNDLE_CONTEXT_PARAM);
        if (bundleContextAttributeName == null) {
            bundleContextAttributeName = DEFAULT_BUNDLE_CONTEXT_ATTRIBUTE;
        }
        if ((bc = (BundleContext)sc.getAttribute(bundleContextAttributeName)) == null) {
            sc.log("Failed to startup blueprint container: no BundleContext is available");
        }
        return bc;
    }

    private BlueprintExtenderService getBlueprintExtenderService(BundleContext bc) {
        ServiceReference sref = bc.getServiceReference(BlueprintExtenderService.class.getName());
        if (sref != null) {
            return (BlueprintExtenderService)bc.getService(sref);
        }
        return null;
    }
}

