/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.db.install;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.opennms.core.db.install.Index;

public class IndexDao {
    private Map<String, Index> m_nameMap;
    private Map<String, List<Index>> m_tableMap;

    public IndexDao() {
        this.reset();
    }

    public void reset() {
        this.m_nameMap = new LinkedHashMap<String, Index>();
        this.m_tableMap = new HashMap<String, List<Index>>();
    }

    public void add(Index i) {
        String lowerName = i.getName().toLowerCase();
        if (this.m_nameMap.containsKey(lowerName)) {
            throw new IllegalArgumentException("Index with name of '" + lowerName + "' already exists.");
        }
        this.m_nameMap.put(lowerName, i);
        this.getIndexesForTableCreateIfEmpty(i.getTable().toLowerCase()).add(i);
    }

    private List<Index> getIndexesForTableCreateIfEmpty(String table) {
        if (!this.m_tableMap.containsKey(table)) {
            this.m_tableMap.put(table, new LinkedList());
        }
        return this.m_tableMap.get(table);
    }

    public List<Index> getIndexesForTable(String table) {
        String lowerName = table.toLowerCase();
        if (!this.m_tableMap.containsKey(lowerName)) {
            return new LinkedList<Index>();
        }
        return this.m_tableMap.get(lowerName);
    }

    public Collection<Index> getAllIndexes() {
        return Collections.unmodifiableCollection(this.m_nameMap.values());
    }

    public void remove(String indexName) {
        String lowerName = indexName.toLowerCase();
        Index index = this.m_nameMap.remove(lowerName);
        if (index == null) {
            throw new IllegalArgumentException("Index with name of '" + lowerName + "' does not exist.");
        }
        for (List<Index> indexes : this.m_tableMap.values()) {
            for (Index i : indexes) {
                if (!index.equals(i)) continue;
                indexes.remove(i);
                return;
            }
        }
    }
}

