/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.db.install;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.StringUtils;

public class Constraint {
    public static final int PRIMARY_KEY = 1;
    public static final int FOREIGN_KEY = 2;
    public static final int CHECK = 3;
    private String m_name;
    private int m_type;
    private String m_table;
    private List<String> m_columns;
    private String m_ftable;
    private List<String> m_fcolumns;
    private String m_fdeltype;
    private String m_fupdtype;
    private String m_checkExpression;

    public Constraint(String table, String constraint) throws Exception {
        this.parse(constraint);
        this.setTable(table);
    }

    public Constraint(String table, String name, List<String> columns) {
        this.setTable(table);
        this.setName(name);
        this.setType(1);
        this.setColumns(columns);
    }

    public Constraint(String table, String name, List<String> columns, String ftable, List<String> fcolumns, String fupdtype, String fdeltype) throws Exception {
        this.setTable(table);
        this.setName(name);
        this.setType(2);
        this.setColumns(columns);
        this.setForeignTable(ftable);
        this.setForeignColumns(fcolumns);
        this.setForeignUpdType(fupdtype);
        this.setForeignDelType(fdeltype);
    }

    public Constraint(String table, String name, String checkExpression) {
        this.setTable(table);
        this.setName(name);
        this.setCheckExpression(checkExpression);
        this.setType(3);
    }

    public final void setForeignUpdType(String fupdtype) {
        this.m_fupdtype = fupdtype;
    }

    public final String getForeignUpdType() {
        return this.m_fupdtype;
    }

    public final String getName() {
        return this.m_name;
    }

    public final void setName(String name) {
        this.m_name = name.toLowerCase();
    }

    public final int getType() {
        return this.m_type;
    }

    public final void setType(int type) {
        this.m_type = type;
    }

    public boolean isPrimaryKeyConstraint() {
        return this.m_type == 1;
    }

    public boolean isForeignKeyConstraint() {
        return this.m_type == 2;
    }

    public boolean isCheckConstraint() {
        return this.m_type == 3;
    }

    public final String getTable() {
        return this.m_table;
    }

    public final void setTable(String table) {
        this.m_table = table;
    }

    public final void setColumns(List<String> columns) {
        this.m_columns = new ArrayList<String>(columns.size());
        for (String i : columns) {
            this.m_columns.add(i.toLowerCase());
        }
    }

    public final List<String> getColumns() {
        return this.m_columns;
    }

    public final void setColumn(String column) {
        ArrayList<String> columns = new ArrayList<String>(1);
        columns.add(column.toLowerCase());
        this.setColumns(columns);
    }

    public final String getForeignTable() {
        return this.m_ftable;
    }

    public final void setForeignTable(String ftable) {
        this.m_ftable = ftable.toLowerCase();
    }

    public final List<String> getForeignColumns() {
        return this.m_fcolumns;
    }

    public final void setForeignColumn(String fcolumn) {
        ArrayList<String> fcolumns = new ArrayList<String>(1);
        fcolumns.add(fcolumn.toLowerCase());
        this.setForeignColumns(fcolumns);
    }

    public final void setForeignColumns(List<String> fcolumns) {
        ArrayList<String> newFcolumns = new ArrayList<String>(fcolumns.size());
        for (String fcolumn : fcolumns) {
            newFcolumns.add(fcolumn.toLowerCase());
        }
        this.m_fcolumns = newFcolumns;
    }

    public final String getForeignDelType() {
        return this.m_fdeltype;
    }

    public final void setForeignDelType(String fdeltype) throws Exception {
        if (!(fdeltype.equals("a") || fdeltype.equals("c") || fdeltype.equals("r") || fdeltype.equals("n") || fdeltype.equals("d"))) {
            throw new Exception("confdeltype \"" + fdeltype + "\" unknown");
        }
        this.m_fdeltype = fdeltype;
    }

    public final String getCheckExpression() {
        return this.m_checkExpression;
    }

    public final void setCheckExpression(String expression) {
        this.m_checkExpression = expression;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("constraint ");
        b.append(this.m_name);
        switch (this.m_type) {
            case 1: {
                b.append(" primary key (");
                if (this.m_columns.size() == 0) {
                    throw new IllegalStateException("Primary key has zero constrained columns... not allowed!");
                }
                b.append(StringUtils.collectionToDelimitedString(this.m_columns, (String)", "));
                break;
            }
            case 2: {
                b.append(" foreign key (");
                if (this.m_columns.size() == 0) {
                    throw new IllegalStateException("Foreign key has zero constrained columns... not allowed!");
                }
                b.append(StringUtils.collectionToDelimitedString(this.m_columns, (String)", "));
                break;
            }
            case 3: {
                b.append(" check (");
                if (this.m_checkExpression == null || this.m_checkExpression.length() == 0) {
                    throw new IllegalStateException("Check constraint has no check expression... not allowed!");
                }
                b.append(this.m_checkExpression);
            }
        }
        b.append(")");
        if (this.m_type == 2) {
            b.append(" references ");
            b.append(this.m_ftable);
            b.append(" (");
            b.append(StringUtils.collectionToDelimitedString(this.m_fcolumns, (String)", "));
            b.append(")");
        }
        if ("c".equals(this.m_fdeltype)) {
            b.append(" on delete cascade");
        } else if ("r".equals(this.m_fdeltype)) {
            b.append(" on delete restrict");
        } else if ("n".equals(this.m_fdeltype)) {
            b.append(" on delete set null");
        } else if ("d".equals(this.m_fdeltype)) {
            b.append(" on delete set default");
        }
        if ("c".equals(this.m_fupdtype)) {
            b.append(" on update cascade");
        }
        return b.toString();
    }

    private void parse(String constraintSQL) throws Exception {
        Matcher m = Pattern.compile("(?i)constraint (\\S+) primary key \\((.*)\\)").matcher(constraintSQL);
        if (m.matches()) {
            this.setName(m.group(1));
            this.setType(1);
            String[] columns = m.group(2).split("\\s*,\\s*");
            this.setColumns(Arrays.asList(columns));
            return;
        }
        m = Pattern.compile("(?i)constraint (\\S+) check \\((.*)\\)").matcher(constraintSQL);
        if (m.matches()) {
            this.setName(m.group(1));
            this.setType(3);
            this.setCheckExpression(m.group(2));
            return;
        }
        m = Pattern.compile("(?i)constraint (\\S+)\\s+foreign key\\s+\\(([^\\(\\)]+)\\)\\s+references\\s+(\\S+)(?:\\s+\\(([^\\(\\)]+)\\))?(\\s+on\\s+delete\\s+(?:(cascade)|(restrict)|(set\\s+null)|(set\\s+default)))?(\\s+on\\s+update\\s+cascade)?").matcher(constraintSQL);
        if (!m.matches()) {
            throw new Exception("Cannot parse constraint: " + constraintSQL);
        }
        this.setName(m.group(1));
        this.setType(2);
        String[] columns = m.group(2).split("\\s*,\\s*");
        this.setColumns(Arrays.asList(columns));
        this.setForeignTable(m.group(3));
        String[] foreignColumns = m.group(4) == null ? m.group(2).split("\\s*,\\s*") : m.group(4).split("\\s*,\\s*");
        this.setForeignColumns(Arrays.asList(foreignColumns));
        if (m.group(5) == null) {
            this.setForeignDelType("a");
        } else if (m.group(6) != null) {
            this.setForeignDelType("c");
        } else if (m.group(7) != null) {
            this.setForeignDelType("r");
        } else if (m.group(8) != null) {
            this.setForeignDelType("n");
        } else if (m.group(9) != null) {
            this.setForeignDelType("d");
        } else {
            throw new Exception("Invalid on delete constraint: " + m.group(5) + ": for constraint: " + constraintSQL);
        }
        if (m.group(10) == null) {
            this.setForeignUpdType("a");
        } else {
            this.setForeignUpdType("c");
        }
    }

    public boolean equals(Object other_o) {
        return this.equals(other_o, false);
    }

    public boolean equals(Object other_o, boolean ignoreFdelType) {
        if (other_o == null || !(other_o instanceof Constraint)) {
            return false;
        }
        Constraint other = (Constraint)other_o;
        if (this.m_name == null && other.getName() != null || this.m_name != null && other.getName() == null) {
            return false;
        }
        if (this.m_name != null && other.getName() != null && !this.m_name.equals(other.getName())) {
            return false;
        }
        if (this.m_type != other.getType()) {
            return false;
        }
        if (this.m_table == null && other.getTable() != null || this.m_table != null && other.getTable() == null) {
            return false;
        }
        if (this.m_table != null && other.getTable() != null && !this.m_table.equals(other.getTable())) {
            return false;
        }
        if (this.m_columns == null && other.getColumns() != null || this.m_columns != null && other.getColumns() == null) {
            return false;
        }
        if (this.m_columns != null && other.getColumns() != null && !this.m_columns.equals(other.getColumns())) {
            return false;
        }
        if (this.m_ftable == null && other.getForeignTable() != null || this.m_ftable != null && other.getForeignTable() == null) {
            return false;
        }
        if (this.m_ftable != null && other.getForeignTable() != null && !this.m_ftable.equals(other.getForeignTable())) {
            return false;
        }
        if (this.m_fcolumns == null && other.getForeignColumns() != null || this.m_fcolumns != null && other.getForeignColumns() == null) {
            return false;
        }
        if (this.m_fcolumns != null && other.getForeignColumns() != null && !this.m_fcolumns.equals(other.getForeignColumns())) {
            return false;
        }
        if (!ignoreFdelType) {
            if (this.m_fdeltype == null && other.getForeignDelType() != null || this.m_fdeltype != null && other.getForeignDelType() == null) {
                return false;
            }
            if (this.m_fdeltype != null && other.m_fdeltype != null && !this.m_fdeltype.equals(other.getForeignDelType())) {
                return false;
            }
            if (this.m_fupdtype == null && other.getForeignUpdType() != null || this.m_fupdtype != null && other.getForeignUpdType() == null) {
                return false;
            }
            if (this.m_fupdtype != null && other.m_fupdtype != null && !this.m_fupdtype.equals(other.getForeignUpdType())) {
                return false;
            }
        }
        return this.m_checkExpression == null || other.getCheckExpression() == null || this.m_checkExpression.equals(other.getCheckExpression());
    }

    public int hashCode() {
        return this.m_name.hashCode() + Integer.valueOf(this.m_type).hashCode() + this.m_columns.hashCode() + this.m_ftable.hashCode() + this.m_fcolumns.hashCode() + this.m_fdeltype.hashCode();
    }
}

