/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.api.reporting.parameter;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opennms.api.reporting.ReportFormat;
import org.opennms.api.reporting.ReportMode;
import org.opennms.api.reporting.parameter.ReportDateParm;
import org.opennms.api.reporting.parameter.ReportDoubleParm;
import org.opennms.api.reporting.parameter.ReportFloatParm;
import org.opennms.api.reporting.parameter.ReportIntParm;
import org.opennms.api.reporting.parameter.ReportParm;
import org.opennms.api.reporting.parameter.ReportStringParm;
import org.opennms.api.reporting.parameter.ReportTimezoneParm;

public class ReportParameters
implements Serializable {
    private static final long serialVersionUID = -3848794546173077375L;
    protected String m_reportId;
    protected ReportFormat m_format;
    protected List<ReportDateParm> m_dateParms;
    protected List<ReportStringParm> m_stringParms;
    protected List<ReportIntParm> m_intParms;
    protected List<ReportFloatParm> m_floatParms;
    protected List<ReportDoubleParm> m_doubleParms;
    protected List<ReportTimezoneParm> m_timezoneParms;

    public List<ReportDateParm> getDateParms() {
        return this.m_dateParms;
    }

    public void setDateParms(List<ReportDateParm> dateParms) {
        this.m_dateParms = dateParms;
    }

    public List<ReportStringParm> getStringParms() {
        return this.m_stringParms;
    }

    public void setStringParms(List<ReportStringParm> strings) {
        this.m_stringParms = strings;
    }

    public List<ReportIntParm> getIntParms() {
        return this.m_intParms;
    }

    public void setIntParms(List<ReportIntParm> ints) {
        this.m_intParms = ints;
    }

    public List<ReportFloatParm> getFloatParms() {
        return this.m_floatParms;
    }

    public void setFloatParms(List<ReportFloatParm> floats) {
        this.m_floatParms = floats;
    }

    public List<ReportDoubleParm> getDoubleParms() {
        return this.m_doubleParms;
    }

    public void setDoubleParms(List<ReportDoubleParm> doubleParms) {
        this.m_doubleParms = doubleParms;
    }

    public void setReportId(String reportId) {
        this.m_reportId = reportId;
    }

    public String getReportId() {
        return this.m_reportId;
    }

    public void setFormat(ReportFormat format) {
        this.m_format = format;
    }

    public ReportFormat getFormat() {
        return this.m_format;
    }

    public void setTimezoneParms(List<ReportTimezoneParm> timezoneParms) {
        this.m_timezoneParms = timezoneParms;
    }

    public List<ReportTimezoneParm> getTimezoneParms() {
        return this.m_timezoneParms;
    }

    public Map<String, Object> getReportParms(ReportMode mode) {
        HashMap<String, Object> parmMap = new HashMap<String, Object>();
        if (this.m_stringParms != null) {
            for (ReportStringParm reportStringParm : this.m_stringParms) {
                parmMap.put(reportStringParm.getName(), reportStringParm.getValue());
            }
        }
        if (this.m_dateParms != null) {
            for (ReportDateParm reportDateParm : this.m_dateParms) {
                parmMap.put(reportDateParm.getName(), reportDateParm.getValue(mode));
            }
        }
        if (this.m_intParms != null) {
            for (ReportIntParm reportIntParm : this.m_intParms) {
                parmMap.put(reportIntParm.getName(), reportIntParm.getValue());
            }
        }
        if (this.m_floatParms != null) {
            for (ReportFloatParm reportFloatParm : this.m_floatParms) {
                parmMap.put(reportFloatParm.getName(), reportFloatParm.getValue());
            }
        }
        if (this.m_doubleParms != null) {
            for (ReportDoubleParm reportDoubleParm : this.m_doubleParms) {
                parmMap.put(reportDoubleParm.getName(), reportDoubleParm.getValue());
            }
        }
        if (this.m_timezoneParms != null) {
            for (ReportTimezoneParm reportTimezoneParm : this.m_timezoneParms) {
                parmMap.put(reportTimezoneParm.getName(), reportTimezoneParm.getValue());
            }
        }
        return parmMap;
    }

    public Map<String, Object> getReportParms() {
        return this.getReportParms(ReportMode.IMMEDIATE);
    }

    public List<? extends ReportParm> getParameters() {
        return Lists.newArrayList((Object[])new List[]{this.m_stringParms, this.m_dateParms, this.m_doubleParms, this.m_floatParms, this.m_intParms, this.m_timezoneParms}).stream().filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
    }

    protected <T extends ReportParm> Map<String, T> asMap() {
        Map reportMap = this.getParameters().stream().collect(Collectors.toMap(p -> p.getName(), Function.identity()));
        return reportMap;
    }

    public <T extends ReportParm> T getParameter(String key) {
        Objects.requireNonNull(key);
        Optional<ReportParm> any = this.getParameters().stream().filter(param -> key.equals(param.getName())).findAny();
        if (any.isPresent()) {
            return (T)any.get();
        }
        return null;
    }

    public void apply(ReportParameters parameters) {
        Objects.requireNonNull(parameters);
        Map reportParmMap = this.asMap();
        Map othersParmMap = parameters.asMap();
        othersParmMap.entrySet().forEach(e -> {
            if (!reportParmMap.containsKey(e.getKey())) {
                throw new IllegalArgumentException("Cannot apply property of name " + (String)e.getKey());
            }
            if (((ReportParm)reportParmMap.get(e.getKey())).getClass() != ((ReportParm)othersParmMap.get(e.getKey())).getClass()) {
                throw new IllegalArgumentException("Cannot apply property of name " + (String)e.getKey() + " due to type mismatch. Expected: " + String.valueOf(((ReportParm)reportParmMap.get(e.getKey())).getClass()) + "Actual: " + String.valueOf(((ReportParm)othersParmMap.get(e.getKey())).getClass()));
            }
            ReportParm thisReportParm = (ReportParm)reportParmMap.get(e.getKey());
            ReportParm otherReportParm = (ReportParm)e.getValue();
            if (thisReportParm instanceof ReportStringParm) {
                ((ReportStringParm)thisReportParm).setValue(((ReportStringParm)otherReportParm).getValue());
            } else if (thisReportParm instanceof ReportDoubleParm) {
                ((ReportDoubleParm)thisReportParm).setValue(((ReportDoubleParm)otherReportParm).getValue());
            } else if (thisReportParm instanceof ReportIntParm) {
                ((ReportIntParm)thisReportParm).setValue(((ReportIntParm)otherReportParm).getValue());
            } else if (thisReportParm instanceof ReportFloatParm) {
                ((ReportFloatParm)thisReportParm).setValue(((ReportFloatParm)otherReportParm).getValue());
            } else if (thisReportParm instanceof ReportDateParm) {
                ReportDateParm thisReportDateParm = (ReportDateParm)thisReportParm;
                ReportDateParm othersReportDateParm = (ReportDateParm)otherReportParm;
                thisReportDateParm.setUseAbsoluteDate(othersReportDateParm.getUseAbsoluteDate());
                thisReportDateParm.setDate(othersReportDateParm.getDate());
                thisReportDateParm.setHours(othersReportDateParm.getHours());
                thisReportDateParm.setMinutes(othersReportDateParm.getMinutes());
                thisReportDateParm.setCount(othersReportDateParm.getCount());
                thisReportDateParm.setInterval(othersReportDateParm.getInterval());
                thisReportDateParm.setIsAdjustedDate(othersReportDateParm.isAdjustedDate());
            } else if (thisReportParm instanceof ReportTimezoneParm) {
                ((ReportTimezoneParm)thisReportParm).setValue(((ReportTimezoneParm)otherReportParm).getValue());
            } else {
                throw new IllegalArgumentException("Unknown parameter type " + String.valueOf(otherReportParm.getClass()) + " of property with name " + (String)e.getKey());
            }
        });
    }
}

