/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.service.api;

import java.util.List;
import org.opennms.netmgt.enlinkd.service.api.BridgePort;
import org.opennms.netmgt.enlinkd.service.api.MacCloud;
import org.opennms.netmgt.enlinkd.service.api.MacPort;
import org.opennms.netmgt.enlinkd.service.api.Topology;

public class TopologyShared
implements Topology {
    private MacCloud cloud;
    private final BridgePort designated;
    private final List<BridgePort> left;
    private final List<MacPort> right;

    public TopologyShared(List<BridgePort> left, List<MacPort> right, BridgePort top) {
        this.designated = top;
        this.left = left;
        this.right = right;
    }

    public List<BridgePort> getBridgePorts() {
        return this.left;
    }

    public List<MacPort> getMacPorts() {
        return this.right;
    }

    public BridgePort getUpPort() {
        return this.designated;
    }

    public MacCloud getCloud() {
        return this.cloud;
    }

    public void setCloud(MacCloud cloud) {
        this.cloud = cloud;
    }

    @Override
    public String printTopology() {
        StringBuilder strbfr = new StringBuilder();
        strbfr.append("shared -> designated bridge:[");
        strbfr.append(this.designated.printTopology());
        strbfr.append("]\n");
        for (BridgePort blink : this.left) {
            strbfr.append("        -> port:");
            if (blink == null) {
                strbfr.append("[null]");
            } else {
                strbfr.append(blink.printTopology());
            }
            strbfr.append("\n");
        }
        for (MacPort port : this.right) {
            strbfr.append("        -> macs:");
            strbfr.append(port.printTopology());
        }
        if (this.cloud != null) {
            strbfr.append("        -> macs:");
            strbfr.append(this.cloud.printTopology());
        }
        return strbfr.toString();
    }
}

