/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.snmp;

import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpRowResult;
import org.opennms.netmgt.snmp.TableTracker;

public class Dot1dBasePortTableTracker
extends TableTracker {
    public static final SnmpObjId DOT1D_BASE_PORT_OID = SnmpObjId.get((String)".1.3.6.1.2.1.17.1.4.1.1");
    public static final SnmpObjId DOT1D_BASE_IFINDEX_OID = SnmpObjId.get((String)".1.3.6.1.2.1.17.1.4.1.2");
    public static final String DOT1D_BASE_IFINDEX = "dot1dBasePortIfIndex";
    public static final String DOT1D_BASE_PORT = "dot1dBasePort";
    public static final SnmpObjId[] bridgePort_elemList = new SnmpObjId[]{DOT1D_BASE_PORT_OID, DOT1D_BASE_IFINDEX_OID};

    public Dot1dBasePortTableTracker() {
        super(bridgePort_elemList);
    }

    public SnmpRowResult createRowResult(int columnCount, SnmpInstId instance) {
        return new Dot1dBasePortRow(columnCount, instance);
    }

    public void rowCompleted(SnmpRowResult row) {
        this.processDot1dBasePortRow((Dot1dBasePortRow)row);
    }

    public void processDot1dBasePortRow(Dot1dBasePortRow row) {
        System.out.printf("\t\t%s (%s)= %s \n", String.valueOf(DOT1D_BASE_PORT_OID) + "." + row.getInstance().toString(), DOT1D_BASE_PORT, row.getBaseBridgePort());
        System.out.printf("\t\t%s (%s)= %s \n", String.valueOf(DOT1D_BASE_IFINDEX_OID) + "." + row.getInstance().toString(), DOT1D_BASE_IFINDEX, row.getBaseBridgePortIfindex());
    }

    public static class Dot1dBasePortRow
    extends SnmpRowResult {
        public Dot1dBasePortRow(int columnCount, SnmpInstId instance) {
            super(columnCount, instance);
        }

        public Integer getBaseBridgePort() {
            return this.getValue(DOT1D_BASE_PORT_OID).toInt();
        }

        public Integer getBaseBridgePortIfindex() {
            return this.getValue(DOT1D_BASE_IFINDEX_OID).toInt();
        }
    }
}

