/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.snmp;

import org.opennms.netmgt.enlinkd.model.VlanStatus;
import org.opennms.netmgt.enlinkd.model.VlanType;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpRowResult;
import org.opennms.netmgt.snmp.TableTracker;

public class CiscoVtpVlanTableTracker
extends TableTracker {
    public static final SnmpObjId CISCO_VTP_VLAN_TABLE_ENTRY = SnmpObjId.get((String)".1.3.6.1.4.1.9.9.46.1.3.1.1");
    public static final String CISCO_VTP_VLAN_STATE = "vtpVlanState";
    public static final String CISCO_VTP_VLAN_TYPE = "vtpVlanType";
    public static final String CISCO_VTP_VLAN_NAME = "vtpVlanName";
    public static final SnmpObjId CISCO_VTP_VLAN_STATE_OID = SnmpObjId.get((SnmpObjId)CISCO_VTP_VLAN_TABLE_ENTRY, (String)"2");
    public static final SnmpObjId CISCO_VTP_VLAN_TYPE_OID = SnmpObjId.get((SnmpObjId)CISCO_VTP_VLAN_TABLE_ENTRY, (String)"3");
    public static final SnmpObjId CISCO_VTP_VLAN_NAME_OID = SnmpObjId.get((SnmpObjId)CISCO_VTP_VLAN_TABLE_ENTRY, (String)"4");
    public static SnmpObjId[] cisco_vlan_elemList = new SnmpObjId[]{CISCO_VTP_VLAN_STATE_OID, CISCO_VTP_VLAN_TYPE_OID, CISCO_VTP_VLAN_NAME_OID};

    public CiscoVtpVlanTableTracker() {
        super(cisco_vlan_elemList);
    }

    public SnmpRowResult createRowResult(int columnCount, SnmpInstId instance) {
        return new CiscoVtpVlanRow(columnCount, instance);
    }

    public void rowCompleted(SnmpRowResult row) {
        this.processCiscoVtpVlanRow((CiscoVtpVlanRow)row);
    }

    public void processCiscoVtpVlanRow(CiscoVtpVlanRow row) {
        System.out.printf("\t\t%s (%s)= %s (%s)\n", String.valueOf(CISCO_VTP_VLAN_STATE_OID) + "." + row.getVlanIndex(), CISCO_VTP_VLAN_STATE, row.getVlanStatus().getIntCode(), VlanStatus.getVlanStatusString((Integer)row.getVlanStatus().getIntCode()));
        System.out.printf("\t\t%s (%s)= %s (%s)\n", String.valueOf(CISCO_VTP_VLAN_TYPE_OID) + "." + row.getVlanIndex(), CISCO_VTP_VLAN_TYPE, row.getVlanType().getIntCode(), VlanType.getVlanTypeString((Integer)row.getVlanType().getIntCode()));
        System.out.printf("\t\t%s (%s)= %s \n", String.valueOf(CISCO_VTP_VLAN_NAME_OID) + "." + row.getVlanIndex(), CISCO_VTP_VLAN_NAME, row.getVlanName());
    }

    public static class CiscoVtpVlanRow
    extends SnmpRowResult {
        public CiscoVtpVlanRow(int columnCount, SnmpInstId instance) {
            super(columnCount, instance);
        }

        public VlanStatus getVlanStatus() {
            return VlanStatus.get((Integer)this.getValue(CISCO_VTP_VLAN_STATE_OID).toInt());
        }

        public VlanType getVlanType() {
            return VlanType.get((Integer)this.getValue(CISCO_VTP_VLAN_TYPE_OID).toInt());
        }

        public Integer getVlanIndex() {
            return this.getInstance().getLastSubId();
        }

        public String getVlanName() {
            return this.getValue(CISCO_VTP_VLAN_NAME_OID).toDisplayString();
        }

        public boolean isStatusOperational() {
            return this.getVlanStatus().equals((Object)VlanStatus.CISCOVTP_OPERATIONAL);
        }

        public boolean isTypeEthernet() {
            return this.getVlanType().equals((Object)VlanType.CISCO_VTP_ETHERNET);
        }
    }
}

