/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.internal.samplers;

import io.jaegertracing.internal.exceptions.SamplingStrategyErrorException;
import io.jaegertracing.internal.metrics.InMemoryMetricsFactory;
import io.jaegertracing.internal.metrics.Metrics;
import io.jaegertracing.internal.samplers.HttpSamplingManager;
import io.jaegertracing.internal.samplers.PerOperationSampler;
import io.jaegertracing.internal.samplers.ProbabilisticSampler;
import io.jaegertracing.internal.samplers.RateLimitingSampler;
import io.jaegertracing.internal.samplers.SamplingStatus;
import io.jaegertracing.internal.samplers.http.OperationSamplingParameters;
import io.jaegertracing.internal.samplers.http.ProbabilisticSamplingStrategy;
import io.jaegertracing.internal.samplers.http.RateLimitingSamplingStrategy;
import io.jaegertracing.internal.samplers.http.SamplingStrategyResponse;
import io.jaegertracing.spi.Sampler;
import io.jaegertracing.spi.SamplingManager;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteControlledSampler
implements Sampler {
    private static final Logger log = LoggerFactory.getLogger(RemoteControlledSampler.class);
    public static final String TYPE = "remote";
    private static final int DEFAULT_POLLING_INTERVAL_MS = 60000;
    private final int maxOperations = 2000;
    private final SamplingManager manager;
    private volatile Sampler sampler;
    private final String serviceName;
    private final Timer pollTimer;
    private final Metrics metrics;

    private RemoteControlledSampler(Builder builder) {
        this.serviceName = builder.serviceName;
        this.manager = builder.samplingManager;
        this.metrics = builder.metrics;
        this.sampler = builder.initialSampler != null ? builder.initialSampler : new ProbabilisticSampler(0.001);
        this.pollTimer = new Timer(true);
        this.pollTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    RemoteControlledSampler.this.updateSampler();
                }
                catch (Exception e) {
                    log.error("Failed to update sampler", e);
                }
            }
        }, 0L, (long)builder.pollingIntervalMs);
    }

    void updateSampler() {
        SamplingStrategyResponse response;
        try {
            response = this.manager.getSamplingStrategy(this.serviceName);
            this.metrics.samplerRetrieved.inc(1L);
        }
        catch (SamplingStrategyErrorException e) {
            this.metrics.samplerQueryFailure.inc(1L);
            return;
        }
        if (response.getOperationSampling() != null) {
            this.updatePerOperationSampler(response.getOperationSampling());
        } else {
            this.updateRateLimitingOrProbabilisticSampler(response);
        }
    }

    private void updateRateLimitingOrProbabilisticSampler(SamplingStrategyResponse response) {
        Sampler sampler;
        if (response.getProbabilisticSampling() != null) {
            ProbabilisticSamplingStrategy strategy = response.getProbabilisticSampling();
            sampler = new ProbabilisticSampler(strategy.getSamplingRate());
        } else if (response.getRateLimitingSampling() != null) {
            RateLimitingSamplingStrategy strategy = response.getRateLimitingSampling();
            sampler = new RateLimitingSampler(strategy.getMaxTracesPerSecond());
        } else {
            this.metrics.samplerParsingFailure.inc(1L);
            log.error("No strategy present in response. Not updating sampler.");
            return;
        }
        if (!this.sampler.equals(sampler)) {
            this.sampler = sampler;
            this.metrics.samplerUpdated.inc(1L);
        }
    }

    private void updatePerOperationSampler(OperationSamplingParameters samplingParameters) {
        Sampler currentSampler = this.sampler;
        if (currentSampler instanceof PerOperationSampler) {
            if (((PerOperationSampler)currentSampler).update(samplingParameters)) {
                this.metrics.samplerUpdated.inc(1L);
            }
        } else {
            this.sampler = new PerOperationSampler(2000, samplingParameters);
            this.metrics.samplerUpdated.inc(1L);
        }
    }

    @Override
    public SamplingStatus sample(String operation, long id) {
        return this.sampler.sample(operation, id);
    }

    public boolean equals(Object sampler) {
        if (this == sampler) {
            return true;
        }
        if (sampler instanceof RemoteControlledSampler) {
            RemoteControlledSampler remoteSampler = (RemoteControlledSampler)sampler;
            return this.sampler.equals(remoteSampler.sampler);
        }
        return false;
    }

    @Override
    public void close() {
        this.pollTimer.cancel();
    }

    public String toString() {
        return "RemoteControlledSampler(maxOperations=" + this.maxOperations + ", manager=" + this.manager + ", sampler=" + this.getSampler() + ")";
    }

    Sampler getSampler() {
        return this.sampler;
    }

    public static class Builder {
        private final String serviceName;
        private SamplingManager samplingManager;
        private Sampler initialSampler;
        private Metrics metrics;
        private int pollingIntervalMs = 60000;

        public Builder(String serviceName) {
            this.serviceName = serviceName;
        }

        public Builder withSamplingManager(SamplingManager samplingManager) {
            this.samplingManager = samplingManager;
            return this;
        }

        public Builder withInitialSampler(Sampler initialSampler) {
            this.initialSampler = initialSampler;
            return this;
        }

        public Builder withMetrics(Metrics metrics) {
            this.metrics = metrics;
            return this;
        }

        public Builder withPollingInterval(int pollingIntervalMs) {
            this.pollingIntervalMs = pollingIntervalMs;
            return this;
        }

        public RemoteControlledSampler build() {
            if (this.samplingManager == null) {
                this.samplingManager = new HttpSamplingManager();
            }
            if (this.initialSampler == null) {
                this.initialSampler = new ProbabilisticSampler(0.001);
            }
            if (this.metrics == null) {
                this.metrics = new Metrics(new InMemoryMetricsFactory());
            }
            return new RemoteControlledSampler(this);
        }
    }
}

