/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.reporting.core.svclayer.support;

import java.util.Calendar;
import java.util.List;
import java.util.stream.Collectors;
import org.opennms.api.reporting.parameter.ReportDateParm;
import org.opennms.api.reporting.parameter.ReportIntParm;
import org.opennms.api.reporting.parameter.ReportParameters;
import org.opennms.api.reporting.parameter.ReportStringParm;
import org.opennms.netmgt.config.reporting.DefaultTime;
import org.opennms.netmgt.config.reporting.Parameters;
import org.opennms.reporting.core.svclayer.ParameterConversionService;

public class DefaultParameterConversionService
implements ParameterConversionService {
    @Override
    public ReportParameters convert(Parameters configParameters) {
        ReportParameters reportParameters = new ReportParameters();
        if (configParameters == null) {
            return reportParameters;
        }
        List dateParms = configParameters.getDateParms().stream().map(dp -> {
            ReportDateParm dateParm = new ReportDateParm();
            dateParm.setUseAbsoluteDate((Boolean)dp.getUseAbsoluteDate().orElse(null));
            dateParm.setDisplayName(dp.getDisplayName());
            dateParm.setName(dp.getName());
            dateParm.setCount(new Integer(dp.getDefaultCount()));
            dateParm.setInterval(dp.getDefaultInterval());
            Calendar cal = Calendar.getInstance();
            if (dp.getDefaultTime().isPresent()) {
                DefaultTime defaultTime = (DefaultTime)dp.getDefaultTime().get();
                dateParm.setHours(defaultTime.getHours());
                cal.set(11, dateParm.getHours());
                dateParm.setMinutes(defaultTime.getMinutes());
                cal.set(12, dateParm.getMinutes());
            } else {
                cal.set(11, 0);
                cal.set(12, 0);
            }
            cal.set(13, 0);
            cal.set(14, 0);
            int amount = 0 - dp.getDefaultCount();
            if (dp.getDefaultInterval().equals("year")) {
                cal.add(1, amount);
            } else if (dp.getDefaultInterval().equals("month")) {
                cal.add(2, amount);
            } else {
                cal.add(5, amount);
            }
            dateParm.setDate(cal.getTime());
            return dateParm;
        }).collect(Collectors.toList());
        reportParameters.setDateParms(dateParms);
        List stringParms = configParameters.getStringParms().stream().map(sp -> {
            ReportStringParm stringParm = new ReportStringParm();
            stringParm.setDisplayName(sp.getDisplayName());
            stringParm.setName(sp.getName());
            stringParm.setInputType(sp.getInputType());
            stringParm.setValue(sp.getDefault());
            return stringParm;
        }).collect(Collectors.toList());
        reportParameters.setStringParms(stringParms);
        List intParms = configParameters.getIntParms().stream().map(ip -> {
            ReportIntParm intParm = new ReportIntParm();
            intParm.setDisplayName(ip.getDisplayName());
            intParm.setName(ip.getName());
            intParm.setInputType(ip.getInputType());
            intParm.setValue(ip.getDefault().intValue());
            return intParm;
        }).collect(Collectors.toList());
        reportParameters.setIntParms(intParms);
        return reportParameters;
    }
}

