/*
 * Decompiled with CFR 0.152.
 */
package org.openbmp.api.parsed.processor;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.openbmp.api.helpers.split;
import org.openbmp.api.parsed.message.RouterPojo;

public class Router {
    public List<RouterPojo> records;

    public Router(String data) {
        this.records = this.parseData(data);
    }

    List<RouterPojo> parseData(String data) {
        List<String> records = split.getStrings(data, '\n', 5000);
        ArrayList<RouterPojo> results = new ArrayList<RouterPojo>();
        for (String record : records) {
            if (record.length() <= 3) continue;
            RouterPojo entry = this.parseRecord(record);
            results.add(entry);
        }
        return results;
    }

    RouterPojo parseRecord(String data) {
        List<String> fields = split.getStrings(data, '\t', 500);
        RouterPojo pojo = new RouterPojo();
        try {
            pojo.setAction(fields.get(0));
            pojo.setSequence(BigInteger.valueOf(Long.valueOf(fields.get(1))));
            pojo.setName(fields.get(2));
            pojo.setHash(fields.get(3));
            pojo.setIp_address(fields.get(4));
            pojo.setDescription(fields.get(5));
            pojo.setTerm_code(fields.get(6).length() > 0 ? Integer.valueOf(fields.get(6)) : 0);
            pojo.setTerm_reason(fields.get(7));
            pojo.setInit_data(fields.get(8));
            pojo.setTerm_data(fields.get(9));
            pojo.setTimestamp(fields.get(10));
            pojo.setBgp_id(fields.get(11));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return pojo;
    }
}

