/*
 * Decompiled with CFR 0.152.
 */
package org.openbmp.api.helpers;

import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class IpAddr {
    public static Boolean isIPv4(String ip_address) {
        Boolean ipv4 = null;
        InetAddress ipaddr = null;
        try {
            ipaddr = InetAddress.getByName(ip_address);
            byte[] addr = ipaddr.getAddress();
            ipv4 = addr.length > 4 ? Boolean.valueOf(false) : Boolean.valueOf(true);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return ipv4;
    }

    public static byte[] getIpBytes(String ip_address) {
        byte[] addr = null;
        InetAddress ipaddr = null;
        try {
            ipaddr = InetAddress.getByName(ip_address);
            addr = ipaddr.getAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return addr;
    }

    public static String resolveIp(String ip_address) {
        String hostname = new String();
        InetAddress ipaddr = null;
        try {
            ipaddr = InetAddress.getByName(ip_address);
            hostname = ipaddr.getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return hostname;
    }

    public static String getIpHex(String ip_address) {
        StringBuilder hex_binary_ip = new StringBuilder();
        InetAddress ipaddr = null;
        try {
            ipaddr = InetAddress.getByName(ip_address);
            byte[] addr = ipaddr.getAddress();
            for (int i = 0; i < addr.length; ++i) {
                hex_binary_ip.append(String.format("%02X", addr[i]));
            }
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return hex_binary_ip.toString();
    }

    public static String getIpBits(String ip_address) {
        StringBuilder bit_ip = new StringBuilder();
        InetAddress ipaddr = null;
        try {
            ipaddr = InetAddress.getByName(ip_address);
            byte[] addr = ipaddr.getAddress();
            for (int i = 0; i < addr.length; ++i) {
                for (int i_bit = 7; i_bit >= 0; --i_bit) {
                    if ((addr[i] & 1 << i_bit) != 0) {
                        bit_ip.append('1');
                        continue;
                    }
                    bit_ip.append('0');
                }
            }
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return bit_ip.toString();
    }

    public static String getIpBroadcastHex(String ip_address, int bits) {
        StringBuilder hex_binary_ip = new StringBuilder();
        InetAddress ipaddr = null;
        if (bits == 0) {
            int bytes = 4;
            if (ip_address.indexOf(58) >= 0) {
                bytes = 16;
            }
            for (int i = 0; i < bytes; ++i) {
                hex_binary_ip.append("FF");
            }
        } else {
            try {
                int i;
                ipaddr = InetAddress.getByName(ip_address);
                byte[] addr = ipaddr.getAddress();
                int remaining_bits = addr.length * 8 - bits;
                BigInteger bcast = new BigInteger(addr);
                for (i = 0; i < remaining_bits; ++i) {
                    if (bcast.testBit(i)) continue;
                    bcast = bcast.flipBit(i);
                }
                addr = bcast.toByteArray();
                for (i = 0; i < addr.length; ++i) {
                    hex_binary_ip.append(String.format("%02X", addr[i]));
                }
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }
        return hex_binary_ip.toString();
    }
}

