/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.support.builder;

import com.google.common.base.MoreObjects;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opennms.core.utils.LocationUtils;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.support.builder.AbstractResource;
import org.opennms.netmgt.collection.support.builder.Resource;
import org.opennms.netmgt.model.ResourcePath;

public class LatencyTypeResource
extends AbstractResource {
    private final String serviceName;
    private final String ipAddress;
    private final String location;
    private final Map<String, String> tags = new HashMap<String, String>();
    private final Map<String, String> serviceParams = new HashMap<String, String>();

    public LatencyTypeResource(String serviceName, String ipAddress, String location) {
        this.serviceName = serviceName;
        this.ipAddress = ipAddress;
        this.location = location;
    }

    @Override
    public Resource getParent() {
        return null;
    }

    @Override
    public String getTypeName() {
        return "latency";
    }

    @Override
    public String getInstance() {
        return this.ipAddress + "[" + this.serviceName + "]";
    }

    @Override
    public String getUnmodifiedInstance() {
        return this.getInstance();
    }

    @Override
    public String getLabel(CollectionResource resource) {
        return null;
    }

    @Override
    public ResourcePath getPath(CollectionResource resource) {
        if (LocationUtils.isDefaultLocationName((String)this.location)) {
            return ResourcePath.get((String[])new String[]{this.ipAddress});
        }
        return ResourcePath.get((String[])new String[]{ResourcePath.sanitize((String)this.location), this.ipAddress});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LatencyTypeResource that = (LatencyTypeResource)o;
        return Objects.equals(this.serviceName, that.serviceName) && Objects.equals(this.ipAddress, that.ipAddress) && Objects.equals(this.location, that.location);
    }

    public int hashCode() {
        return Objects.hash(this.serviceName, this.ipAddress, this.location);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("serviceName", (Object)this.serviceName).add("ipAddress", (Object)this.ipAddress).add("location", (Object)this.location).toString();
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public Map<String, String> getTags() {
        return this.tags;
    }

    public void addTag(String name, String value) {
        this.tags.put(name, value);
    }

    @Override
    public Map<String, String> getServiceParams() {
        return this.serviceParams;
    }

    public void addServiceParam(String name, String value) {
        this.serviceParams.put(name, value);
    }
}

