/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.scheduler.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.karaf.scheduler.core.QuartzSchedulerStorage;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.core.QuartzScheduler;
import org.quartz.impl.StdScheduler;

public class KarafStdScheduler
extends StdScheduler {
    private final QuartzSchedulerStorage storage = new QuartzSchedulerStorage();

    public KarafStdScheduler(QuartzScheduler scheduler) {
        super(scheduler);
    }

    QuartzSchedulerStorage getStorage() {
        return this.storage;
    }

    @Override
    public Date scheduleJob(JobDetail jobDetail, Trigger trigger) throws SchedulerException {
        JobDataMap context = (JobDataMap)jobDetail.getJobDataMap().get("QuartzJobScheduler.Context");
        this.storage.put((Serializable)((Object)jobDetail.getKey().toString()), context);
        jobDetail.getJobDataMap().remove("QuartzJobScheduler.Context");
        Date date = super.scheduleJob(jobDetail, trigger);
        return date;
    }

    @Override
    public boolean deleteJob(JobKey jobKey) throws SchedulerException {
        String contextKey = jobKey.toString();
        if (contextKey != null) {
            this.storage.release((Serializable)((Object)contextKey));
        }
        return super.deleteJob(jobKey);
    }

    @Override
    public boolean deleteJobs(List<JobKey> jobKeys) throws SchedulerException {
        if (jobKeys != null) {
            ArrayList<String> contextKeys = new ArrayList<String>();
            for (JobKey jobKey : jobKeys) {
                contextKeys.add(jobKey.toString());
            }
            for (String contextKey : contextKeys) {
                this.storage.release((Serializable)((Object)contextKey));
            }
        }
        return super.deleteJobs(jobKeys);
    }

    @Override
    public boolean unscheduleJob(TriggerKey triggerKey) throws SchedulerException {
        String contextKey;
        Trigger trigger = this.getTrigger(triggerKey);
        String string = contextKey = trigger.getJobKey() != null ? trigger.getJobKey().toString() : null;
        if (contextKey != null) {
            this.storage.release((Serializable)((Object)contextKey));
        }
        return super.unscheduleJob(triggerKey);
    }

    @Override
    public boolean unscheduleJobs(List<TriggerKey> triggerKeys) throws SchedulerException {
        if (triggerKeys != null) {
            ArrayList<String> contextKeys = new ArrayList<String>();
            for (TriggerKey triggerKey : triggerKeys) {
                Trigger trigger = this.getTrigger(triggerKey);
                String contextKey = trigger.getJobKey().toString();
                if (contextKey == null) continue;
                contextKeys.add(contextKey);
            }
            for (String contextKey : contextKeys) {
                this.storage.release((Serializable)((Object)contextKey));
            }
        }
        return super.unscheduleJobs(triggerKeys);
    }
}

