/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.scheduler.core;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.apache.karaf.scheduler.ScheduleOptions;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;

public class InternalScheduleOptions
implements ScheduleOptions {
    private static final long serialVersionUID = -2632689849349264449L;
    public String name;
    public boolean canRunConcurrently = false;
    public Map<String, Serializable> configuration;
    public String schedule;
    private Date date;
    private int times;
    private long period;
    private String expression;

    public InternalScheduleOptions(Date date) {
        this.date = date;
        this.times = 0;
        this.period = 0L;
        this.schedule = null;
        this.expression = null;
    }

    public InternalScheduleOptions(Date date, int times, long period) {
        this.date = date;
        this.times = times;
        this.period = period;
        this.schedule = null;
        this.expression = null;
    }

    public InternalScheduleOptions(String expression) {
        this.date = null;
        this.times = 0;
        this.period = 0L;
        this.schedule = null;
        this.expression = expression;
    }

    @Override
    public ScheduleOptions config(Map<String, Serializable> config) {
        this.configuration = config;
        return this;
    }

    @Override
    public ScheduleOptions name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public ScheduleOptions canRunConcurrently(boolean flag) {
        this.canRunConcurrently = flag;
        return this;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean canRunConcurrently() {
        return this.canRunConcurrently;
    }

    @Override
    public String schedule() {
        return this.schedule;
    }

    private String formatDate(Date date) {
        if (date == null) {
            return "null";
        }
        Calendar c = GregorianCalendar.getInstance();
        c.setTime(date);
        return DatatypeConverter.printDateTime((Calendar)c);
    }

    public TriggerBuilder<? extends Trigger> compile() {
        TriggerBuilder<Trigger> trigger = null;
        if (this.expression == null) {
            if (this.date == null) {
                throw new IllegalArgumentException("Date can't be null");
            }
            boolean dateOnly = false;
            if (this.times < 2 && this.times != -1) {
                dateOnly = true;
            }
            if (this.period < 1L) {
                dateOnly = true;
            }
            if (dateOnly) {
                trigger = TriggerBuilder.newTrigger().startAt(this.date);
                this.schedule = "at(" + this.formatDate(this.date) + ")";
            } else {
                SimpleScheduleBuilder simpleScheduleBuilder = this.times == -1 ? SimpleScheduleBuilder.simpleSchedule().repeatForever() : SimpleScheduleBuilder.simpleSchedule().withRepeatCount(this.times - 1);
                trigger = TriggerBuilder.newTrigger().startAt(this.date).withSchedule(simpleScheduleBuilder.withIntervalInMilliseconds(this.period * 1000L));
                this.schedule = "at(" + this.formatDate(this.date) + ", " + this.times + ", " + this.period + ")";
            }
        } else {
            if (!CronExpression.isValidExpression(this.expression)) {
                throw new IllegalArgumentException("Expression is not valid: " + this.expression);
            }
            trigger = TriggerBuilder.newTrigger().withSchedule(CronScheduleBuilder.cronSchedule(this.expression));
            this.schedule = "cron(" + this.expression + ")";
        }
        return trigger;
    }
}

