/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist.foreignsource;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.joda.time.Duration;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.provision.persist.StringIntervalAdapter;
import org.opennms.netmgt.provision.persist.foreignsource.PluginConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="foreign-source")
@ValidateUsing(value="foreign-sources.xsd")
public class ForeignSource
implements Serializable,
Comparable<ForeignSource> {
    private static final Logger LOG = LoggerFactory.getLogger(ForeignSource.class);
    private static final long serialVersionUID = -1903289015976502808L;
    @XmlAttribute(name="name", required=true)
    @NotNull
    private String m_name;
    @XmlAttribute(name="date-stamp")
    protected XMLGregorianCalendar m_dateStamp;
    @XmlElement(name="scan-interval")
    @XmlJavaTypeAdapter(value=StringIntervalAdapter.class)
    private Duration m_scanInterval = Duration.standardDays((long)1L);
    @XmlElementWrapper(name="detectors")
    @XmlElement(name="detector")
    private List<PluginConfig> m_detectors = new ArrayList<PluginConfig>();
    @XmlElementWrapper(name="policies")
    @XmlElement(name="policy")
    private List<PluginConfig> m_policies = new ArrayList<PluginConfig>();
    private boolean m_default;

    public ForeignSource() {
        this.updateDateStamp();
    }

    public ForeignSource(String name) {
        this();
        this.setName(name);
    }

    @XmlTransient
    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    @XmlTransient
    public Duration getScanInterval() {
        return this.m_scanInterval;
    }

    public void setScanInterval(Duration scanInterval) {
        this.m_scanInterval = scanInterval;
    }

    @XmlTransient
    public XMLGregorianCalendar getDateStamp() {
        return this.m_dateStamp;
    }

    @XmlTransient
    public Date getDateStampAsDate() {
        return this.m_dateStamp == null ? null : this.m_dateStamp.toGregorianCalendar().getTime();
    }

    public void setDateStamp(XMLGregorianCalendar value) {
        this.m_dateStamp = value;
    }

    public void updateDateStamp() {
        try {
            this.m_dateStamp = DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar());
        }
        catch (DatatypeConfigurationException e) {
            LOG.warn("unable to update datestamp", (Throwable)e);
        }
    }

    @XmlTransient
    public List<PluginConfig> getDetectors() {
        return this.m_detectors;
    }

    public void setDetectors(List<PluginConfig> detectors) {
        this.m_detectors = detectors;
    }

    @XmlTransient
    public List<String> getDetectorNames() {
        ArrayList<String> names = new ArrayList<String>(this.m_detectors.size());
        for (PluginConfig detector : this.m_detectors) {
            names.add(detector.getName());
        }
        return names;
    }

    @XmlTransient
    public List<PluginConfig> getPolicies() {
        return this.m_policies;
    }

    public void setPolicies(List<PluginConfig> policies) {
        this.m_policies = policies;
    }

    public void addDetector(PluginConfig detector) {
        this.m_detectors.add(detector);
    }

    public void addPolicy(PluginConfig policy) {
        this.m_policies.add(policy);
    }

    public PluginConfig getDetector(String detector) {
        for (PluginConfig pc : this.m_detectors) {
            if (!pc.getName().equals(detector)) continue;
            return pc;
        }
        return null;
    }

    public void deleteDetectors(PluginConfig detector) {
        this.m_detectors.remove(detector);
    }

    public PluginConfig getPolicy(String policy) {
        for (PluginConfig pc : this.m_policies) {
            if (!pc.getName().equals(policy)) continue;
            return pc;
        }
        return null;
    }

    public void deletePolicies(PluginConfig policy) {
        this.m_policies.remove(policy);
    }

    public boolean isDefault() {
        return this.m_default;
    }

    @XmlTransient
    public void setDefault(boolean isDefault) {
        this.m_default = isDefault;
    }

    public int hashCode() {
        int prime = 109;
        int result = 1;
        result = 109 * result + (this.m_dateStamp == null ? 0 : this.m_dateStamp.hashCode());
        result = 109 * result + (this.m_default ? 1231 : 1237);
        result = 109 * result + (this.m_detectors == null ? 0 : this.m_detectors.hashCode());
        result = 109 * result + (this.m_name == null ? 0 : this.m_name.hashCode());
        result = 109 * result + (this.m_policies == null ? 0 : this.m_policies.hashCode());
        result = 109 * result + (this.m_scanInterval == null ? 0 : this.m_scanInterval.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ForeignSource)) {
            return false;
        }
        ForeignSource other = (ForeignSource)obj;
        if (this.m_dateStamp == null ? other.m_dateStamp != null : !this.m_dateStamp.equals(other.m_dateStamp)) {
            return false;
        }
        if (this.m_default != other.m_default) {
            return false;
        }
        if (this.m_detectors == null ? other.m_detectors != null : !this.m_detectors.equals(other.m_detectors)) {
            return false;
        }
        if (this.m_name == null ? other.m_name != null : !this.m_name.equals(other.m_name)) {
            return false;
        }
        if (this.m_policies == null ? other.m_policies != null : !this.m_policies.equals(other.m_policies)) {
            return false;
        }
        return !(this.m_scanInterval == null ? other.m_scanInterval != null : !this.m_scanInterval.equals((Object)other.m_scanInterval));
    }

    public String toString() {
        return "ForeignSource [name=" + this.m_name + ", dateStamp=" + String.valueOf(this.m_dateStamp) + ", scanInterval=" + String.valueOf(this.m_scanInterval) + ", detectors=" + String.valueOf(this.m_detectors) + ", policies=" + String.valueOf(this.m_policies) + ", default=" + this.m_default + "]";
    }

    @Override
    public int compareTo(ForeignSource other) {
        return new CompareToBuilder().append((Object)this.m_name, (Object)other.m_name).toComparison();
    }
}

