/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist;

import com.google.common.io.Files;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class JSR223ScriptCache {
    private final Map<String, ScriptState> m_scriptStates = new ConcurrentHashMap<String, ScriptState>();
    private final ScriptEngineManager m_scriptManager = new ScriptEngineManager();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompiledScript getCompiledScript(File scriptFile) throws IOException, ScriptException {
        Objects.requireNonNull(scriptFile, "scriptFile must not be null");
        ScriptState state = this.m_scriptStates.computeIfAbsent(scriptFile.getAbsolutePath(), k -> new ScriptState());
        Object object = state.lock;
        synchronized (object) {
            long lastModified = scriptFile.lastModified();
            if (lastModified > state.lastCompiled) {
                String fileExtension = Files.getFileExtension((String)scriptFile.getAbsolutePath());
                ScriptEngine engine = this.m_scriptManager.getEngineByExtension(fileExtension);
                if (engine == null) {
                    throw new IllegalStateException("No engine found for file extension: " + fileExtension);
                }
                if (!(engine instanceof Compilable)) {
                    throw new IllegalStateException("Only engines that can compile scripts are supported: " + engine.getClass().getCanonicalName());
                }
                Compilable compilable = (Compilable)((Object)engine);
                try (FileReader reader = new FileReader(scriptFile);){
                    state.compiledScript = compilable.compile(reader);
                }
                state.lastCompiled = lastModified;
            }
        }
        return state.compiledScript;
    }

    private static class ScriptState {
        private final Object lock = new Object();
        private long lastCompiled = -1L;
        private CompiledScript compiledScript = null;

        private ScriptState() {
        }
    }
}

