/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.util.Arrays;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.springframework.util.Assert;

@XmlRootElement(name="prefab-graph")
@XmlAccessorType(value=XmlAccessType.NONE)
public class PrefabGraph
implements Comparable<PrefabGraph> {
    @XmlAttribute(name="name")
    private String m_name;
    @XmlAttribute(name="title")
    private String m_title;
    @XmlElement(name="columns")
    private String[] m_columns;
    @XmlElement(name="command")
    private String m_command;
    @XmlElement(name="externalValues")
    private String[] m_externalValues;
    @XmlElement(name="propertiesValues")
    private String[] m_propertiesValues;
    @XmlAttribute(name="order")
    private int m_order;
    @XmlElement(name="types")
    private String[] m_types = new String[0];
    @XmlAttribute(name="description")
    private String m_description;
    @XmlAttribute(name="width")
    private Integer m_graphWidth;
    @XmlAttribute(name="height")
    private Integer m_graphHeight;
    @XmlElement(name="suppress")
    private String[] m_suppress;

    private PrefabGraph() {
        throw new UnsupportedOperationException("No-arg constructor for JAXB.");
    }

    public PrefabGraph(String name, String title, String[] columns, String command, String[] externalValues, String[] propertiesValues, int order, String[] types, String description, Integer graphWidth, Integer graphHeight, String[] suppress) {
        Assert.notNull((Object)name, (String)"name argument cannot be null");
        Assert.notNull((Object)title, (String)"title argument cannot be null");
        Assert.notNull((Object)columns, (String)"columns argument cannot be null");
        Assert.notNull((Object)command, (String)"command argument cannot be null");
        Assert.notNull((Object)externalValues, (String)"externalValues argument cannot be null");
        Assert.notNull((Object)propertiesValues, (String)"propertiesValues argument cannot be null");
        Assert.notNull((Object)suppress, (String)"suppress argument cannot be null");
        this.m_name = name;
        this.m_title = title;
        this.m_columns = Arrays.copyOf(columns, columns.length);
        this.m_command = command;
        this.m_externalValues = Arrays.copyOf(externalValues, externalValues.length);
        this.m_propertiesValues = Arrays.copyOf(propertiesValues, propertiesValues.length);
        this.m_order = order;
        this.m_suppress = Arrays.copyOf(suppress, suppress.length);
        this.m_types = types == null ? null : Arrays.copyOf(types, types.length);
        this.m_description = description;
        this.m_graphWidth = graphWidth;
        this.m_graphHeight = graphHeight;
    }

    public String getName() {
        return this.m_name;
    }

    public String getTitle() {
        return this.m_title;
    }

    public int getOrder() {
        return this.m_order;
    }

    public String[] getColumns() {
        return this.m_columns;
    }

    public String getCommand() {
        return this.m_command;
    }

    public String[] getExternalValues() {
        return this.m_externalValues;
    }

    public String[] getPropertiesValues() {
        return this.m_propertiesValues;
    }

    public String[] getTypes() {
        return this.m_types;
    }

    public boolean hasMatchingType(String ... matchingTypes) {
        for (String matchingType : matchingTypes) {
            for (String type : this.m_types) {
                if (type == null || !type.equals(matchingType)) continue;
                return true;
            }
        }
        return false;
    }

    public String getDescription() {
        return this.m_description;
    }

    public Integer getGraphWidth() {
        return this.m_graphWidth;
    }

    public Integer getGraphHeight() {
        return this.m_graphHeight;
    }

    public String[] getSuppress() {
        return this.m_suppress;
    }

    @Override
    public int compareTo(PrefabGraph other) {
        if (other == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        return this.getOrder() - other.getOrder();
    }
}

