/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.jmxconfiggenerator.jmxconfig.query;

import java.util.regex.Pattern;
import javax.management.MBeanAttributeInfo;

public class FilterCriteria {
    public String objectName;
    public String attributeName;

    FilterCriteria() {
    }

    public FilterCriteria(String objectName, String attributeName) {
        this.objectName = objectName;
        this.attributeName = attributeName;
    }

    public static FilterCriteria parse(String input) {
        FilterCriteria qd = new FilterCriteria();
        String[] split = input.split(":");
        if (split.length == 3) {
            qd.objectName = input.substring(0, input.lastIndexOf(":"));
            qd.attributeName = input.substring(input.lastIndexOf(":") + 1);
        } else {
            qd.objectName = input;
        }
        return qd;
    }

    public String toString() {
        if (this.attributeName != null) {
            return this.objectName + ":" + this.attributeName;
        }
        return this.objectName;
    }

    public boolean matches(MBeanAttributeInfo eachAttribute) {
        Pattern pattern = this.attributeName != null ? Pattern.compile(this.attributeName) : null;
        return pattern == null || pattern.matcher(eachAttribute.getName()).matches();
    }
}

